//
//  JvmaHandler.m
//  JvmaSample
//
//  Created by mac on 2017/4/20.
//  Copyright © 2017年 mac. All rights reserved.
//

#import "JvmaHandler.h"
#import "RecordCellModel.h"
#import "DataItemCellModel.h"
@implementation JvmaHandler{
    AsReaderAsk *ask;
    JvmaSDK *sdk;
    BOOL more;
    dispatch_queue_t queue;
    System *system;
    BLEManager *mBLEManager;
}

static JvmaHandler *sharedJvmaHandler;

- (instancetype)init
{
    self = [super init];
    if (self) {
        system = [System sharedSystem];
        ask = [system ask];
        [ask setStatusDelegate:self];
        sdk = [system sdk];
        [ask removeAllAsReaderAskLog];
        [ask setAsReaderAskLogOn:YES];
        [sdk removeAllSdkLog];
        [sdk setSDKLogOn:YES];
        queue =  dispatch_queue_create("AsReaderPower",DISPATCH_QUEUE_SERIAL);
        mBLEManager = [BLEManager sharedBLEManager];
        mBLEManager.delegate = self;
        [mBLEManager setBluetoothLogOn:YES];
        [mBLEManager removeAllBluetoothLog];
    }
    
    return self;
}

+ (JvmaHandler*)sharedJvmaHandler{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        sharedJvmaHandler = [[JvmaHandler alloc] init];
    });
    return sharedJvmaHandler;
}
- (void)getVmDataWithPassword:(NSString *)password terminalPassword:(NSString *)terminalPassword inputTimeRecord:(BOOL)inputTimeRecord dataIDArray:(NSArray*)dataIDArray{
    @try {
        
        NSMutableArray * array = [NSMutableArray array];
        JvmaDataId *dataid;
        
        for (NSString *dataIDStr in dataIDArray) {
            JvmaDataIdCode dataID = strtoul([dataIDStr UTF8String], NULL, 16);
            if (![self haveDataId:dataID]) {
                if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenErrorReceivedMessageResult:)] ){
                    [[self delegate]whenErrorReceivedMessageResult:@"Not found JvmaDataIdCode"];
                }
                return;
            }
            dataid = [[JvmaDataId alloc] initWithDataIdCode:dataID];
            [array  addObject:dataid];
        }
        if (array.count == 0) {
            array = nil;
        }
        if (sdk) {
            [sdk getVmDataWithSettingCode:password terminalPassword:terminalPassword dataIds:array inputTimeRecord:inputTimeRecord resultDataBlock:^(JvmaResult *resultDataBlock) {
                [self getResultMessage:resultDataBlock];
            }];
        }else{
            [self getResultMessage:nil];
        }
    } @catch (NSException *exception) {
        if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenErrorReceivedMessageResult:)] ){
            [[self delegate]whenErrorReceivedMessageResult:[NSString stringWithFormat:@"%@\n%@",exception.name,exception.reason]];
        }
    } @finally {
        
    }
}

- (void)getVmDataClearWithPassword:(NSString *)password terminalPassword:(NSString *)terminalPassword inputTimeRecord:(BOOL)inputTimeRecord dataIDArray:(NSArray*)dataIDArray retryTime:(NSString *)time  buttonStatus:(NSInteger)button{
    @try {
        
        NSMutableArray * array = [NSMutableArray array];
        JvmaDataId *dataid;
        
        for (NSString *dataIDStr in dataIDArray) {
            JvmaDataIdCode dataID = strtoul([dataIDStr UTF8String], NULL, 16);
            if (![self haveDataId:dataID]) {
                if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenErrorReceivedMessageResult:)] ){
                    [[self delegate]whenErrorReceivedMessageResult:@"Not found JvmaDataIdCode"];
                }
                return;
            }
            dataid = [[JvmaDataId alloc] initWithDataIdCode:dataID];
            [array  addObject:dataid];
        }
        
        if (array.count == 0) {
            array = nil;
        }
        if(sdk){
            if (button == 0) {
                [sdk getVmDataClearWithSettingCode:password terminalPassword:terminalPassword dataIds:array inputTimeRecord:inputTimeRecord resultDataBlock:^(JvmaResult *resultDataBlock) {
                    [self getResultMessage:resultDataBlock];
                } clearResultDataBlock:^(JvmaResult *resultDataBlock) {
                    [self getResultMessage:resultDataBlock];
                }
                 
                ];
            } else if (button == 1) {
                [sdk getVmDataClearWithRetryTimes:[time intValue] settingCode:password terminalPassword:terminalPassword dataIds:array inputTimeRecord:inputTimeRecord resultDataBlock:^(JvmaResult *resultDataBlock) {
                    [self getResultMessage:resultDataBlock];
                }];
            }
        }else{
            [self getResultMessage:nil];
        }
    } @catch (NSException *exception) {
        if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenErrorReceivedMessageResult:)] ){
            [[self delegate]whenErrorReceivedMessageResult:[NSString stringWithFormat:@"%@\n%@",exception.name,exception.reason]];
        }
    } @finally {
        
    }
}

- (void)collectSettingDataWithPassword:(NSString *)password terminalPassword:(NSString *)terminalPassword inputTimeRecord:(BOOL)inputTimeRecord commandCode:(NSString *)commandCode{
    @try {
        
        CommandCode command = strtoul([commandCode UTF8String], NULL, 16);
        if (![self haveCommandCode:command]) {
            if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenErrorReceivedMessageResult:)] ){
                [[self delegate]whenErrorReceivedMessageResult:@"Not found CommandCode"];
            }
            return;
        }
        if (sdk) {
            [sdk collectSettingDataWithSettingCode:password terminalPassword:terminalPassword commandCode:command inputTimeRecord:inputTimeRecord resultDataBlock:^(JvmaResult *resultDataBlock) {
                [self getResultMessage:resultDataBlock];
            }];
        }else{
            [self getResultMessage:nil];
        }
    } @catch (NSException *exception) {
        if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenErrorReceivedMessageResult:)] ){
            [[self delegate]whenErrorReceivedMessageResult:[NSString stringWithFormat:@"%@\n%@",exception.name,exception.reason]];
        }
    } @finally {
        
    }
}

- (void)sendSettingDataWithPassword:(NSString *)password terminalPassword:(NSString *)terminalPassword inputTimeRecord:(BOOL)inputTimeRecord records:(NSArray *)records commandCode:(NSString*)commandCode {
    @try {
        
        CommandCode command = strtoul([commandCode UTF8String], NULL, 16);
        if (![self haveCommandCode:command]) {
            if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenErrorReceivedMessageResult:)] ){
                [[self delegate]whenErrorReceivedMessageResult:@"Not found CommandCode"];
            }
            return;
        }
        
        NSMutableArray *settingDatas = [NSMutableArray array];
        for (RecordCellModel *recordCellModel in records) {
            NSString *dataIDStr = recordCellModel.dataIdAddCellModel.dataIdText;
            JvmaDataIdCode dataID = strtoul([dataIDStr UTF8String], NULL, 16);
            if (![self haveDataId:dataID]) {
                if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenErrorReceivedMessageResult:)] ){
                    [[self delegate]whenErrorReceivedMessageResult:@"Not found JvmaDataIdCode"];
                }
                return;
            }
            
            NSMutableArray *itemsArray = [NSMutableArray array];
            for (DataItemCellModel *dataItemCellModel in recordCellModel.items) {
                NSString *dataItemStr = dataItemCellModel.itemText;
                if (dataItemStr && ![dataItemStr isEqualToString:@""]) {
                    JvmaItem *item = [[JvmaItem alloc]initWithHexStr:dataItemStr];
                    [itemsArray addObject:item];
                }
            }
            
            JvmaRecord *record = [[JvmaRecord alloc]initWithJvmaDataIdCode:dataID items:itemsArray];
            [settingDatas addObject:record];
        }
        
        if (settingDatas.count == 0) {
            return;
        }
        
        if(sdk){
            [sdk sendSettingDataWithSettingCode:password terminalPassword:terminalPassword settingDatas:settingDatas commandCode:command inputTimeRecord:inputTimeRecord resultDataBlock:^(JvmaResult *resultDataBlock) {
                [self getResultMessage:resultDataBlock];
            }];
        }else{
            [self getResultMessage:nil];
        }
    } @catch (NSException *exception) {
        if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenErrorReceivedMessageResult:)] ){
            [[self delegate]whenErrorReceivedMessageResult:[NSString stringWithFormat:@"%@\n%@",exception.name,exception.reason]];
        }
    } @finally {
        
    }
}

- (void)clearAllDataWithPassword:(NSString *)password terminalPassword:(NSString *)terminalPassword inputTimeRecord:(BOOL)inputTimeRecord{
    @try {
        
        if (sdk) {
            [sdk allClearWithSettingCode:password terminalPassword:terminalPassword inputTimeRecord:inputTimeRecord clearResultDataBlock:^(JvmaResult *resultDataBlock) {
                [self getResultMessage:resultDataBlock];
            }];
        }else{
            [self getResultMessage:nil];
        }
    } @catch (NSException *exception) {
        if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenErrorReceivedMessageResult:)] ){
            [[self delegate]whenErrorReceivedMessageResult:[NSString stringWithFormat:@"%@\n%@",exception.name,exception.reason]];
        }
    } @finally {
        
    }
}

- (void)sendTestDatasWithJvmaDataSendModel:(BOOL)sendModel{
    NSMutableArray *ary = [[NSMutableArray alloc]init];
    if (sendModel) {
        for (int i = 0; i < 100; i++) {
            JvmaItem *item1 = [[JvmaItem alloc]initWithHexStr:[NSString stringWithFormat:@"%ld",(10000000000000+arc4random()%9999999999999)]];
            JvmaItem *item2 = [[JvmaItem alloc]initWithHexStr:[NSString stringWithFormat:@"%ld",10000000000000+arc4random()%9999999999999]];
            JvmaItem *item3 = [[JvmaItem alloc]initWithHexStr:[NSString stringWithFormat:@"%ld",10000000000000+arc4random()%9999999999999]];
            JvmaRecord *record = [[JvmaRecord alloc]initWithJvmaDataIdCode:ShouhinCD items:@[item1,item2,item3]];
            [ary addObject:record];
        }
    }else{
        JvmaItem *item1 = [[JvmaItem alloc]initWithHexStr:[NSString stringWithFormat:@"%ld",(10000000000000+arc4random()%9999999999999)]];
        JvmaItem *item2 = [[JvmaItem alloc]initWithHexStr:[NSString stringWithFormat:@"%ld",10000000000000+arc4random()%9999999999999]];
        JvmaItem *item3 = [[JvmaItem alloc]initWithHexStr:[NSString stringWithFormat:@"%ld",10000000000000+arc4random()%9999999999999]];
        JvmaRecord *record = [[JvmaRecord alloc]initWithJvmaDataIdCode:ShouhinCD items:@[item1,item2,item3]];
        [ary addObject:record];
    }
    if (sdk) {
        
        [sdk sendTestDatasWithJvmaDatas:ary resultDataBlock:^(JvmaResult *resultDataBlock) {
            [self getResultMessage:resultDataBlock];
        }];
    }else{
        [self getResultMessage:nil];
    }
}

- (void)onReceivedConnectedState:(BOOL)isConnected{
    if (isConnected) {
        sleep(1);
        [ask sendPowerOn:YES setBeep:YES setVib:YES setLed:YES];
        [ask setTriggerModeDefault:NO];
        
    }
    
    dispatch_async(dispatch_get_main_queue(), ^{
        if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenReceivedConnectedState:)]) {
            [[self delegate]whenReceivedConnectedState:isConnected];
        }
    });
}

- (void)onReceivedBLEConnectedState:(BOOL)isConnected{
    if (isConnected) {
        sleep(1);
        [ask sendPowerOn:YES setBeep:YES setVib:YES setLed:YES];
        [ask setTriggerModeDefault:NO];
        
    }
    
    dispatch_async(dispatch_get_main_queue(), ^{
        if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenReceivedBLEConnectedState:)]) {
            [[self delegate]whenReceivedBLEConnectedState:isConnected];
        }
    });
}

- (void)onReceivedBLEError:(NSError *)error{
    dispatch_async(dispatch_get_main_queue(), ^{
        if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenReceivedBLEError:)]) {
            [[self delegate]whenReceivedBLEError:error];
        }
    });
}

- (void)onReceivedPowerState:(BOOL)isOn beep:(BOOL)isBeep vib:(BOOL)isVib led:(BOOL)isLed{
    //    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"" message:[NSString stringWithFormat:@"onReceivedPowerState:(%d)isOn beep:(%d)isBeep vib:(%d)isVib led:(%d)isLed",isOn,isBeep,isVib,isLed] delegate:nil cancelButtonTitle:@"OK" otherButtonTitles: nil];
    //    [alert show];
}
- (void)onReceivedReaderSettingBeep:(BOOL)isOn Vib:(BOOL)isVib Led:(BOOL)isLed{
    //    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"" message:[NSString stringWithFormat:@"onReceivedReaderSettingBeep:(%d)isBeep vib:(%d)isVib led:(%d)isLed",isOn,isVib,isLed] delegate:nil cancelButtonTitle:@"OK" otherButtonTitles: nil];
    //    [alert show];
}


- (void)onReceivedBatteryState:(int)gauge{
    if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenReceivedBatteryState:)]) {
        [[self delegate]whenReceivedBatteryState:gauge];
    }
}

- (void)onReceivedTriggerState:(BOOL)isTriggerDown{
    if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenReceivedTriggerState:)]) {
        [[self delegate]whenReceivedTriggerState:isTriggerDown];
    }
}

- (void)getResultMessage:(id)_results{
    NSString * resultStr = @"ERROR";
    
    if ([_results isKindOfClass:[NSString class]]) {
        resultStr = [NSString stringWithFormat:@"ver:%@",_results];
    }else if([_results isKindOfClass:[JvmaResult class]]){
        JvmaResult *results = _results;
        if (results) {
            if (results.error) {
                resultStr = [NSString stringWithFormat:@"ErrorCode:%ld\n%@",(long)results.error.errorCode,results.error.errorMessage];
                // 返回不正常，有错误信息
            }else if (results.nak){
                resultStr = [NSString stringWithFormat:@"NAK:%@\n%@",[[results nak] hexStatus],[[results nak] nakMessage]];
            }
            else if ([results.jvmaTexts count] > 0){
                NSArray *list = [results getAllRecords];
                if (list) {
                    NSString * message = @"Text";
                    //                NSString * title = @"";
                    int b = 1;
                    for (JvmaRecord *jvmaRecord in list) {
                        int i  = 1;
                        message = [message stringByAppendingFormat:@"\nRecord--%d--%@",b,[[jvmaRecord jvmaDataId] hexStrCode]];
                        b ++;
                        for (JvmaItem * jm in jvmaRecord.items ) {
                            message = [message stringByAppendingFormat:@"\nItem--%d--%@",i,jm.hexStr];
                            i++;
                        }
                    }
                    resultStr = [NSString stringWithFormat:@"%@",message];
                }else{
                }
            }
            else if (results.ack){
                resultStr = @"完了";
            }else{
            }
        }
    }
    
    if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenReceivedMessageResult:)] ){
        [[self delegate]whenReceivedMessageResult:resultStr];
    }
    NSDictionary *dic = [[NSDictionary alloc] initWithObjectsAndKeys:@"resultSucceed\n__________\n__________",@"result", nil];
    [[NSNotificationCenter defaultCenter] postNotificationName:@"RESULT" object:nil userInfo:dic];
}

- (NSString *)getJvmaVersion{
    //    NSString * version = [sdk getJvmaModuleVersionBCD];
    if (sdk) {
        [sdk getJvmaModuleVersionResultVersionBlock:^(NSString *version) {
            [self getResultMessage:version];
        }];
    }else{
        [self getResultMessage:nil];
    }
    return nil;
}

- (BOOL)test{
    __block BOOL result = NO;
    if (sdk) {
        [sdk startTestModeThenRun:^(BOOL isTestMode) {
            result = isTestMode;
        }];
    }else{
        [self getResultMessage:nil];
    }
    return result;
}
- (void)restartAsreader{
    dispatch_async(queue, ^{
        
        if([ask sendPowerOn:NO setBeep:NO setVib:NO setLed:NO]){
            dispatch_async(dispatch_get_main_queue(), ^{
                if ([ask isConnected]) {
                    if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenReceivedConnectedState:)]) {
                        [[self delegate]whenReceivedConnectedState:NO];
                    }
                }else if ([ask isBLEConnected]){
                    if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenReceivedBLEConnectedState:)]) {
                        [[self delegate]whenReceivedBLEConnectedState:NO];
                    }
                }

            });
        }
        sleep(1);
        if([ask sendPowerOn:YES setBeep:YES setVib:YES setLed:NO]){
            dispatch_async(dispatch_get_main_queue(), ^{
                if ([ask isConnected]) {
                    if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenReceivedConnectedState:)]) {
                        [[self delegate]whenReceivedConnectedState:YES];
                    }
                }else if ([ask isBLEConnected]){
                    if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenReceivedBLEConnectedState:)]) {
                        [[self delegate]whenReceivedBLEConnectedState:YES];
                    }
                }
            });
        }
    });
}

- (void)setCommunicationRetryTimes:(uint)retryTimes{
    [sdk setCommunicationRetryTimes:retryTimes];
}

- (void)setSendSettingDataRetryTimes:(uint)retryTimes{
    [sdk setSendSettingDataRetryTimes:retryTimes];
}

- (uint)getCommunicationRetryTimes{
    return [sdk getCommunicationRetryTimes];
}

- (uint)getSendSettingDataRetryTimes{
    return [sdk getSendSettingDataRetryTimes];
}

- (BOOL)makeBeep{
    return [ask makeBeep];
}

- (BOOL)makeVibration{
    return [ask makeVibration];
}

- (BOOL)makeBeepVibration{
    return [ask makeBeepVibration];
}

- (NSString *)getSDKVersion{
    return  [JvmaSDK getVersion];
}

- (BOOL)haveDataId:(JvmaDataIdCode)jvmaDataIdCode{
    switch (jvmaDataIdCode) {
        case VmIdentifyCode:
            return YES;
        case CommunicationCommand:
            return YES;
        case ClearStutas:
            return YES;
        case VmTime:
            return YES;
        case ManageData:
            return YES;
        case IndividualData:
            return YES;
        case VmFaultCode:
            return YES;
        case MonitorCode:
            return YES;
        case OfflineLog:
            return YES;
        case SetTotal:
            return YES;
        case SetTotalBackUp:
            return YES;
        case PriceQuantity:
            return YES;
        case DateQuantity:
            return YES;
        case MaterialKindCode:
            return YES;
        case SupMaterialKindCode:
            return YES;
        case SaleAmount:
            return YES;
        case SaleAmountBackUp:
            return YES;
        case ShouhinCD:
            return YES;
        case KindCD:
            return YES;
        case CupKindCD:
            return YES;
        case ColumnCashPrice:
            return YES;
        case ColumnQuantity:
            return YES;
        case ColumnSaleOutTime:
            return YES;
        case ColumnCardPrice:
            return YES;
        case PrepayCardQuantity:
            return YES;
        case PrepayCardSaleAmount:
            return YES;
        case IdCardQuantity:
            return YES;
        case FreeSaleQuantity:
            return YES;
        case InputCashQuantity:
            return YES;
        case QuitCashQuantity:
            return YES;
        case ChangEmptyTime:
            return YES;
        case VmRunTime:
            return YES;
        case MonitorSaleOutTime:
            return YES;
        case MaterialSaleOutTime:
            return YES;
        case SupMaterialSaleOutTime:
            return YES;
        case LargeValueInputQuantity:
            return YES;
        case LargeValueQuitQuantity:
            return YES;
        case LargeValueChangEmptyTime:
            return YES;
        case Total:
            return YES;
        case TotalSaleQuantity:
            return YES;
        case OfflinePassword:
            return YES;
        case TerminalPassword:
            return YES;
        case CenterPasswordRecord:
            return YES;
        case InputMoneyQuantity:
            return YES;
        case ExhaustMoneyQuantity:
            return YES;
        case NoChangeTime:
            return YES;
        case TotalRecords:
            return YES;
        case DataBackupCD:
            return YES;
        case CumulativeRecord:
            return YES;
        case BrandNumberRecord:
            return YES;
        case BrandNameRecord:
            return YES;
        case AllBrandsRecord:
            return YES;
        case AllBrandsDataBackupCD:
            return YES;
        case DifferentBrandsSaleNum:
            return YES;
        case DifferentBrandsSalePrice:
            return YES;
        case BrandSalaQuantity:
            return YES;
        case TotalBrandRecord:
            return YES;
        case OtherBrandSaleQuantity:
            return YES;
        case TotalBrandQuantity:
            return YES;
        case DayTotalRecord1:
            return YES;
        case DayTotalRecord2:
            return YES;
        case DayTotalSales:
            return YES;
        case ColumnRouletteNumber:
            return YES;
        case HighPriceSaleNumRecord:
            return YES;
        case HighPriceOtherSaleRecord:
            return YES;
        case HighPriceOtherCardSale:
            return YES;
        case AnotherCashSaleSetRecord:
            return YES;
        case AnotherCardSaleSetRecord:
            return YES;
        case BrandOtherSalePrice:
            return YES;
        case CashSaleChangeRecord:
            return YES;
        case CardSalePriceChange:
            return YES;
        case BrandOtherSalePriceChange:
            return YES;
        case VersionRecord:
            return YES;
        case TestRecord:
            return YES;
        case SupplyCommand1:
            return YES;
        case SupplyCommand2:
            return YES;
        case CenterIP:
            return YES;
        case VMIP:
            return YES;
        case TcpIPSendNo:
            return YES;
        case AdministrationGroupNo:
            return YES;
        case VMCall:
            return YES;
        case Automaticcalltime:
            return YES;
        case FullRecord:
            return YES;
        case ValueRecord:
            return YES;
        case SetRecord:
            return YES;
        case SpecifiedRecord:
            return YES;
        case CodeRecord:
            return YES;
        case CenterCodeRecord:
            return YES;
        case MaxMaterials:
            return YES;
        case AuxiliaryMaterials:
            return YES;
        case CommercialValueRecord:
            return YES;
        case AuxiliaryValueRecord:
            return YES;
        case CenterPhoneRecord:
            return YES;
        case PortSpecifiedRecord:
            return YES;
        case Datarecovery:
            return YES;
        case MaterialsSupplyRecord:
            return YES;
        case AuxiliaryDataRecord:
            return YES;
        case ConfirmationData:
            return YES;
        case Endconfirmationdata:
            return YES;
        case Downloadsendmode:
            return YES;
        case DownloadSendmode:
            return YES;
        case MachineData:
            return YES;
        case Faultmonitorcode:
            return YES;
        case SellColumn:
            return YES;
        case DifferentMaterials:
            return YES;
        case Auxiliarymaterial:
            return YES;
        case ContainerColumn:
            return YES;
        case SalesReplenishment:
            return YES;
        case QuantityReplenishment:
            return YES;
        case Salesreplenishment:
            return YES;
        case Datagenerationtime:
            return YES;
        case Timedata:
            return YES;
        case Communicationlog:
            return YES;
        case TotalRecovery:
            return YES;
        case AccumulatedSales:
            return YES;
        case CashSalesVolume:
            return YES;
        case PrepaidCardSales:
            return YES;
        case IDCardSalesQuantity:
            return YES;
        case SalesbyBend:
            return YES;
        case IDCardSales:
            return YES;
        case Cumulativeinvestment:
            return YES;
        case Totalexpenditure:
            return YES;
        case CumulativeInvestment:
            return YES;
        case CumulativeExpenditure:
            return YES;
        case SalesduringSampling:
            return YES;
        case Samplingchange:
            return YES;
        case DifferentColumns:
            return YES;
        case SuckerMaterial:
            return YES;
        case Suckermaterial1:
            return YES;
        case CurrentType:
            return YES;
        case PrepaidcardSales:
            return YES;
        case AdvanceCashSales:
            return YES;
        case PrepaidCardSales1:
            return YES;
        case ReebendsSalesQuantity:
            return YES;
        case CumulativeSales:
            return YES;
        case InvestmentTensor:
            return YES;
        case ExpansionRate:
            return YES;
        case InvestmentTensor2:
            return YES;
        case CurrencyType:
            return YES;
        case ConsumptionOfSucker:
            return YES;
        case ConsumptionOfSucker1:
            return YES;
        case SupplementaryQuantity:
            return YES;
        case SupplementaryQuantity1:
            return YES;
        default:
            return NO;
    }
}

-(BOOL)haveCommandCode:(CommandCode)commandCode{
    switch (commandCode) {
        case VmDataCollect:
            return YES;
        case VmDataCollectClear:
            return YES;
        case SettingDataCollect:
            return YES;
        case SettingDataSet:
            return YES;
        case AllClear:
            return YES;
        case VmDataCollectClearConfirm:
            return YES;
        case AllClearConfirm:
            return YES;
        case OnLineSettingDataCollect:
            return YES;
        case OnLineSettingDataSet:
            return YES;
        case OnLineWorkingSettingDataSet:
            return YES;
        case OnLineAllClear:
            return YES;
        case CenterPasswordSet:
            return YES;
        case OnLineAllClearConfirm:
            return YES;
        case TCP_IPSettingDataCollect:
            return YES;
        case TCP_IPSettingDataSet:
            return YES;
        default:
            return NO;
    }
}

- (BOOL)startBluetoothScan{
    return [mBLEManager startScan];
}
- (void)stopBluetoothScan{
    [mBLEManager stopScan];
}

- (void)connectBluetooth:(BluetoothModule *)bluetoothModule{
    [ask connectBluetooth:bluetoothModule];
}
- (void)disConnectBluetooth{
    [ask disConnectBluetooth];
}

#pragma mark - BLEManagerDelegate
- (void)onBluetoothStateDidChange:(CBManagerState)state{
    if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenBluetoothStateDidChange:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [[self delegate]whenBluetoothStateDidChange:state];
        });
    }
}
- (void)onDiscoverBluetoothModule:(BluetoothModule *)bluetoothModule{
    if ([self delegate] && [[self delegate] respondsToSelector:@selector(whenDiscoverBluetoothModule:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [[self delegate]whenDiscoverBluetoothModule:bluetoothModule];
        });
    }
}
@end
