//
//  JvmaHandler.h
//  JvmaSample
//
//  Created by mac on 2017/4/20.
//  Copyright © 2017年 mac. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <JvmaSDK/JvmaSDK.h>
#import <UIKit/UIKit.h>
#import "System.h"
@protocol JvmaHandlerDelegate <NSObject>
- (void)whenReceivedBatteryState:(int)battery;
- (void)whenReceivedConnectedState:(BOOL)isConnected;
- (void)whenReceivedTriggerState:(BOOL)isTriggerDown;
- (void)whenReceivedMessageResult:(NSString *)result;
- (void)whenErrorReceivedMessageResult:(NSString *)result;

- (void)whenReceivedBLEConnectedState:(BOOL)isConnected;
- (void)whenReceivedBLEError:(NSError *)error;

- (void)whenBluetoothStateDidChange:(CBManagerState)state;
- (void)whenDiscoverBluetoothModule:(BluetoothModule *)bluetoothModule;
@end

@interface JvmaHandler : NSObject<AsReaderAskStatusDelegate, BLEManagerDelegate>

@property(nonatomic,assign)NSString *resultMessage;
@property (nonatomic, weak) id<JvmaHandlerDelegate>delegate;
+ (JvmaHandler*)sharedJvmaHandler;

- (void)getVmDataWithPassword:(NSString *)password terminalPassword:(NSString *)terminalPassword inputTimeRecord:(BOOL)inputTimeRecord dataIDArray:(NSArray*)dataIDArray;

- (void)getVmDataClearWithPassword:(NSString *)password terminalPassword:(NSString *)terminalPassword inputTimeRecord:(BOOL)inputTimeRecord dataIDArray:(NSArray*)dataIDArray retryTime:(NSString *)time  buttonStatus:(NSInteger)button;

- (void)collectSettingDataWithPassword:(NSString *)password terminalPassword:(NSString *)terminalPassword inputTimeRecord:(BOOL)inputTimeRecord commandCode:(NSString *)commandCode;

- (void)sendSettingDataWithPassword:(NSString *)password terminalPassword:(NSString *)terminalPassword inputTimeRecord:(BOOL)inputTimeRecord records:(NSArray *)records commandCode:(NSString*)commandCode;

- (void)clearAllDataWithPassword:(NSString *)password terminalPassword:(NSString *)terminalPassword inputTimeRecord:(BOOL)inputTimeRecord;

- (void)sendTestDatasWithJvmaDataSendModel:(BOOL)sendModel;

- (NSString *)getJvmaVersion;

- (BOOL)test;

- (void)restartAsreader;

- (void)setCommunicationRetryTimes:(uint)retryTimes;

- (void)setSendSettingDataRetryTimes:(uint)retryTimes;

- (uint)getCommunicationRetryTimes;

- (uint)getSendSettingDataRetryTimes;

- (BOOL)makeBeep;
- (BOOL)makeVibration;
- (BOOL)makeBeepVibration;

- (BOOL)startBluetoothScan;
- (void)stopBluetoothScan;

- (void)connectBluetooth:(BluetoothModule *)bluetoothModule;
- (void)disConnectBluetooth;

- (NSString *)getSDKVersion;

@end
