//
//  SendCell.m
//  JvmaSample
//
//  Created by mac on 2017/5/31.
//  Copyright © 2017年 mac. All rights reserved.
//

#import "SendCell.h"

@implementation SendCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
    // Configure the view for the selected state
}

- (void)setViewModel:(SendCellModel *)viewModel{
    _viewModel = viewModel;
    self.sendTitle.text = viewModel.title;
    if (viewModel.isTestMode) {
        self.backgroundColor = TestColor;
        
        if (viewModel.cellMode == multipleSend || viewModel.cellMode == individualSend) {
            self.userInteractionEnabled = YES;
            self.sendTitle.backgroundColor = [UIColor colorWithRed:205.0/255 green:202.0/255 blue:46.0/255 alpha:1];
        }else {
            self.userInteractionEnabled = NO;
            [self.sendTitle setBackgroundColor:[UIColor grayColor]];
        }
    }else {
        self.backgroundColor = [UIColor whiteColor];
        if (viewModel.cellMode == multipleSend || viewModel.cellMode == individualSend) {
            self.userInteractionEnabled = NO;
            [self.sendTitle setBackgroundColor:[UIColor grayColor]];
        }else {
            self.userInteractionEnabled = YES;
            [self.sendTitle setBackgroundColor:[UIColor colorWithRed:205.0/255 green:202.0/255 blue:46.0/255 alpha:1]];
            self.sendTitle.textColor = [UIColor blackColor];
        }
    }
}


@end
