//
//  RecordCell.m
//  JvmaSample
//
//  Created by MRX_MacBook on 2020/9/23.
//  Copyright © 2020 mac. All rights reserved.
//

#import "RecordCell.h"
#import "DataItemCellModel.h"
@implementation RecordCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

- (void)setViewModel:(RecordCellModel *)viewModel{
    _viewModel = viewModel;
    [self.tableView setEditing:YES];
    self.tableView.scrollEnabled = NO;
    _viewModel.dataIdAddCellModel.isTestMode = viewModel.isTestMode;
    for (DataItemCellModel *item in viewModel.items) {
        item.isTestMode = viewModel.isTestMode;
    }
    
    [self.tableView reloadData];
    
    if (viewModel.isTestMode) {
        self.userInteractionEnabled = NO;
        self.backgroundColor = TestColor;
    }else {
        self.userInteractionEnabled = YES;
        self.backgroundColor = [UIColor whiteColor];
    }
}


- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _viewModel.items.count + 1;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 60;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0) {
        NSString *cellIdentifier = @"DataIDAddCell";
        DataIDAddCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
        if(!cell) {
            cell = [[[NSBundle mainBundle] loadNibNamed:@"DataIDAddCell" owner:self options:nil] firstObject];
        }
        cell.viewModel = _viewModel.dataIdAddCellModel;
        cell.delegate = self;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    }else {
        NSString *cellIdentifier = @"DataItemCell";
        DataItemCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
        if(!cell) {
            cell = [[[NSBundle mainBundle] loadNibNamed:@"DataItemCell" owner:self options:nil] firstObject];
        }
        cell.viewModel = _viewModel.items[indexPath.row - 1];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    }
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{

}

- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath{
    return YES;
}

- (NSString *)tableView:(UITableView *)tableView titleForDeleteConfirmationButtonForRowAtIndexPath:(NSIndexPath *)indexPath{
    return @"削除";
}

- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath{
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        if (indexPath.row == 0) {
            if (self.delegate && [self.delegate respondsToSelector:@selector(whenDeleteRecord:)]) {
                [self.delegate whenDeleteRecord:_viewModel];
            }
        }else {
            NSMutableArray *array = _viewModel.items;
            [array removeObjectAtIndex:indexPath.row - 1];
            _viewModel.items = array;
            [_tableView deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
            if (self.delegate && [self.delegate respondsToSelector:@selector(whenItemsChanged:)]) {
                [self.delegate whenItemsChanged:_viewModel];
            }
        }
    }
}

- (void)whenClickAdd:(DataIdAddCellModel*)model{
    DataItemCellModel *dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"";
    dataItemCellModel.isTestMode = _viewModel.isTestMode;
    NSMutableArray *array = _viewModel.items;
    [array addObject:dataItemCellModel];;
    _viewModel.items = array;
    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:_viewModel.items.count inSection:0];
    [_tableView beginUpdates];
    [_tableView insertRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationRight];
    [_tableView endUpdates];
    if (self.delegate && [self.delegate respondsToSelector:@selector(whenItemsChanged:)]) {
        [self.delegate whenItemsChanged:_viewModel];
    }
}

@end
