//
//  ItemCell.m
//  JvmaSample
//
//  Created by mac on 2017/5/31.
//  Copyright © 2017年 mac. All rights reserved.
//

#import "ItemCell.h"
#import "JvmaHandler.h"
@implementation ItemCell
- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setViewModel:(ItemCellModel *)viewModel{
    _viewModel = viewModel;
    self.itemLabel.text = viewModel.title;
    self.itemText.text = viewModel.item;
    self.itemText.keyboardType = viewModel.keyboardType;
    self.itemText.attributedPlaceholder = [[NSAttributedString alloc] initWithString:viewModel.placeholder attributes:@{NSFontAttributeName: [UIFont systemFontOfSize:10]}];
    if (viewModel.isTestMode) {
        self.userInteractionEnabled = NO;
        self.backgroundColor = TestColor;
    }else {
        self.userInteractionEnabled = YES;
        self.backgroundColor = [UIColor whiteColor];
    }
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self.itemText resignFirstResponder];
    return YES;
}

- (void)textFieldDidEndEditing: (UITextField *)textField {
    if (_viewModel.saveSendSettingDataRetryTimes) {
        [[JvmaHandler sharedJvmaHandler] setSendSettingDataRetryTimes:[textField.text intValue]];
    }
    _viewModel.item = textField.text;
    [self.itemText resignFirstResponder];
}

- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string{
    NSString *text = textField.text;
    unsigned long length = text.length + string.length - range.length;
    if (_viewModel.inputLength == 0) {
        return YES;
    }else {
        if (length > _viewModel.inputLength) {
            return false;;
        }
        
        if (!string || [string isEqualToString:@""]) {
            return YES;;
        }
        
        if ([@"0123456789ABCDEFabcdef" containsString:string]) {
            NSString *newString = [textField.text stringByReplacingCharactersInRange:range withString:string];
            textField.text = newString.uppercaseString;
        }
        return NO;
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
