//
//  DataItemCell.m
//  JvmaSample
//
//  Created by MRX_MacBook on 2020/9/23.
//  Copyright © 2020 mac. All rights reserved.
//

#import "DataItemCell.h"

@implementation DataItemCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

- (void)setViewModel:(DataItemCellModel *)viewModel{
    _viewModel = viewModel;
    _itemTextField.text = viewModel.itemText;
    if (viewModel.isTestMode) {
        self.userInteractionEnabled = NO;
        self.backgroundColor = TestColor;
    }else {
        self.userInteractionEnabled = YES;
        self.backgroundColor = [UIColor whiteColor];
    }
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self.itemTextField resignFirstResponder];
    return YES;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    _viewModel.itemText = textField.text;
    [self.itemTextField resignFirstResponder];
}

- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string{
    return YES;
}

@end
