//
//  DataIDAddCell.m
//  JvmaSample
//
//  Created by MRX_MacBook on 2020/9/23.
//  Copyright © 2020 mac. All rights reserved.
//

#import "DataIDAddCell.h"

@implementation DataIDAddCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

- (void)setViewModel:(DataIdAddCellModel *)viewModel{
    _viewModel = viewModel;
    _dataIDTestField.text = viewModel.dataIdText;
    if (viewModel.isTestMode) {
        self.userInteractionEnabled = NO;
        self.backgroundColor = TestColor;
    }else {
        self.userInteractionEnabled = YES;
        self.backgroundColor = [UIColor whiteColor];
    }
}

- (IBAction)onClickAdd:(id)sender {
    if (self.delegate && [self.delegate respondsToSelector:@selector(whenClickAdd:)]) {
        [self.delegate whenClickAdd:_viewModel];
    }
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self.dataIDTestField resignFirstResponder];
    return YES;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    _viewModel.dataIdText = textField.text;
    [self.dataIDTestField resignFirstResponder];
}

- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string{
    NSString *text = textField.text;
    unsigned long length = text.length + string.length - range.length;
    if (_viewModel.inputLength == 0) {
        return YES;
    }else {
        if (length > _viewModel.inputLength) {
            return false;;
        }
        
        if (!string || [string isEqualToString:@""]) {
            return YES;;
        }
        
        if ([@"0123456789ABCDEFabcdef" containsString:string]) {
            NSString *newString = [textField.text stringByReplacingCharactersInRange:range withString:string];
            textField.text = newString.uppercaseString;
        }
        return NO;
    }
}

@end
