//
//  CommandCell.m
//  JvmaSample
//
//  Created by MRX_MacBook on 2020/9/23.
//  Copyright © 2020 mac. All rights reserved.
//

#import "CommandCell.h"

@implementation CommandCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

- (void)setViewModel:(CommandCellModel *)viewModel{
    _viewModel = viewModel;
    self.commandTextField.text = viewModel.command;
    if (viewModel.isTestMode) {
        self.userInteractionEnabled = NO;
        self.backgroundColor = TestColor;
    }else {
        self.userInteractionEnabled = YES;
        self.backgroundColor = [UIColor whiteColor];
    }
}


- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self.commandTextField resignFirstResponder];
    return YES;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    _viewModel.command = textField.text;
    [self.commandTextField resignFirstResponder];
}

- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string{
    NSString *text = textField.text;
    unsigned long length = text.length + string.length - range.length;
    if (_viewModel.inputLength == 0) {
        return YES;
    }else {
        if (length > _viewModel.inputLength) {
            return false;;
        }
        
        if (!string || [string isEqualToString:@""]) {
            return YES;;
        }
        
        if ([@"0123456789ABCDEFabcdef" containsString:string]) {
            NSString *newString = [textField.text stringByReplacingCharactersInRange:range withString:string];
            textField.text = newString.uppercaseString;
        }
        return NO;
    }
}

@end
