//
//  JvmaSDK.h
//  JvmaSDK
//
//  Created by DS.Zhang on 2017/2/16.
//  Copyright © 2017年 MRX_DS.Zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "JvmaResult.h"
#import "JvmaDataId.h"
#import "AsReaderAsk.h"
#import "JvmaText.h"

typedef void (^ResultDataBlock)(JvmaResult *resultDataBlock);

typedef void (^TestModeBlock)(BOOL isTestMode);

typedef void (^ResultVersionBlock)(NSString *version);


@interface JvmaSDK : NSObject
- (instancetype)initWithAsReaderAsk:(AsReaderAsk *)asReaderAsk;

- (void)startTestModeThenRun:(TestModeBlock)testModeBlock;;

- (void)sendTestDatasWithJvmaDatas:(NSArray<JvmaRecord*> *)jvmaDatas
                   resultDataBlock:(ResultDataBlock)resultDataBlock;

//--------------------------------------

/**
 *  @brief      Set SDK Timeout
 *  @param      second : Default 30
                         MIN 6
                         If second is 0, No timeout processing will be done
                         If second less than 6 and not 0, then do the timeout processing after 6 seconds.
 */
- (void)setTimeout:(float)second;

- (void)setCommunicationRetryTimes:(uint)retryTimes;

- (void)setSendSettingDataRetryTimes:(uint)retryTimes;

- (uint)getCommunicationRetryTimes;

- (uint)getSendSettingDataRetryTimes;

- (void)setSDKLogOn:(BOOL)on;

- (void)removeAllSdkLog;

+ (NSString *)getVersion;

- (void)startCommunicationWithSettingCode:(NSString *)settingCode
                         terminalPassword:(NSString *)terminalPassword
                          resultDataBlock:(ResultDataBlock)resultDataBlock;

- (void)sendCommandWithSettingCode:(NSString *)settingCode
                  terminalPassword:(NSString *)terminalPassword
                       commandCode:(CommandCode)commandCode
                           dataIds:(NSArray<JvmaDataId*> *)dataIds
                   inputTimeRecord:(BOOL)inputTimeRecord
                   resultDataBlock:(ResultDataBlock)resultDataBlock;

- (void)getVmDataWithSettingCode:(NSString *)settingCode
                terminalPassword:(NSString *)terminalPassword
                         dataIds:(NSArray<JvmaDataId*> *)dataIds
                 inputTimeRecord:(BOOL)inputTimeRecord
                 resultDataBlock:(ResultDataBlock)resultDataBlock;

- (void)getVmDataClearWithSettingCode:(NSString *)settingCode
                     terminalPassword:(NSString *)terminalPassword
                              dataIds:(NSArray<JvmaDataId*> *)dataIds
                      inputTimeRecord:(BOOL)inputTimeRecord
                      resultDataBlock:(ResultDataBlock)resultDataBlock
                 clearResultDataBlock:(ResultDataBlock)clearResultDataBlock;

/**
 *  @brief      GetVmDataClearWithRetryTimes
 *  @param      retryTimes : Default 5
                             If retryTimes is 0, The default value (5) will be used
 */
- (void)getVmDataClearWithRetryTimes:(uint)retryTimes
                         settingCode:(NSString *)settingCode
                    terminalPassword:(NSString *)terminalPassword
                             dataIds:(NSArray<JvmaDataId*> *)dataIds
                     inputTimeRecord:(BOOL)inputTimeRecord
                     resultDataBlock:(ResultDataBlock)resultDataBlock;

- (void)collectSettingDataWithSettingCode:(NSString *)settingCode
                         terminalPassword:(NSString *)terminalPassword
                          inputTimeRecord:(BOOL)inputTimeRecord
                          resultDataBlock:(ResultDataBlock)resultDataBlock;

- (void)collectSettingDataWithSettingCode:(NSString *)settingCode
                         terminalPassword:(NSString *)terminalPassword
                              commandCode:(CommandCode)commandCode
                          inputTimeRecord:(BOOL)inputTimeRecord
                          resultDataBlock:(ResultDataBlock)resultDataBlock;

- (void)sendSettingDataWithSettingCode:(NSString *)settingCode
                      terminalPassword:(NSString *)terminalPassword
                          settingDatas:(NSArray<JvmaRecord*> *)settingDatas
                       inputTimeRecord:(BOOL)inputTimeRecord
                       resultDataBlock:(ResultDataBlock)resultDataBlock;

- (void)sendSettingDataWithSettingCode:(NSString *)settingCode
                      terminalPassword:(NSString *)terminalPassword
                          settingDatas:(NSArray<JvmaRecord*> *)settingDatas
                           commandCode:(CommandCode)commandCode
                       inputTimeRecord:(BOOL)inputTimeRecord
                       resultDataBlock:(ResultDataBlock)resultDataBlock;

- (void)allClearWithSettingCode:(NSString *)settingCode
               terminalPassword:(NSString *)terminalPassword
                inputTimeRecord:(BOOL)inputTimeRecord
           clearResultDataBlock:(ResultDataBlock)clearResultDataBlock;

- (void)onLineAllClearWithSettingCode:(NSString *)settingCode
                     terminalPassword:(NSString *)terminalPassword
                      inputTimeRecord:(BOOL)inputTimeRecord
                 clearResultDataBlock:(ResultDataBlock)clearResultDataBlock;

- (void)sendJvmaDatasWithSettingCode:(NSString *)settingCode
                    terminalPassword:(NSString *)terminalPassword
                           jvmaDatas:(NSArray<JvmaRecord*> *)jvmaDatas
                     resultDataBlock:(ResultDataBlock)resultDataBlock;

- (void)getJvmaModuleVersionResultVersionBlock:(ResultVersionBlock)resultVersionBlock;
@end
