//
//  JvmaResult.h
//  JvmaSDK
//
//  Created by DS.Zhang on 2017/2/20.
//  Copyright © 2017年 MRX_DS.Zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "JvmaError.h"
#import "JvmaNAKData.h"
#import "JvmaACKData.h"
#import "JvmaRecord.h"
#import "JvmaText.h"

@interface JvmaResult : NSObject
@property (nonatomic ,strong ,readonly) JvmaError                   *error;

@property (nonatomic ,strong ,readonly) JvmaACKData                 *ack;
@property (nonatomic ,strong ,readonly) JvmaNAKData                 *nak;
@property (nonatomic ,strong ,readonly) NSMutableArray<JvmaText *> *jvmaTexts;

- (instancetype)initWithOfflinePassword:(NSString *)offlinePassword TerminalPassword:(NSString *)terminalPassword;
- (instancetype)initWithErrorCode:(JvmaErrorCode)errorCode errorClass:(NSString*)errorClass errorLine:(int)errorLine;
- (BOOL)addResultData:(NSData *)resultData textType:(JvmaTextType)textType;
- (NSArray<JvmaRecord*> *)getAllRecords;
- (JvmaRecord *)getRecordWithDataId:(JvmaDataIdCode)dataId;
@end
