//
//  JvmaRecord.h
//  JvmaSDK
//
//  Created by DS.Zhang on 2017/2/20.
//  Copyright © 2017年 MRX_DS.Zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "JvmaItem.h"
#import "JvmaDataId.h"

@interface JvmaRecord : NSObject
@property (nonatomic ,strong, readonly) JvmaDataId *jvmaDataId;
@property (nonatomic ,strong, readonly) NSString   *recordLenghtBCD;
@property (nonatomic ,strong, readonly) NSString   *itemDigitsBCD;
@property (nonatomic ,strong, readonly) NSArray<JvmaItem *>    *items;
@property (nonatomic, strong, readonly) NSString   *hexStr;
@property (nonatomic, strong, readonly) NSData     *data;

@property (nonatomic, assign, readonly) NSUInteger bytes;
- (instancetype)initWithData:(NSData *)data;

- (instancetype)initWithJvmaDataIdCode:(JvmaDataIdCode)jvmaDataIdCode items:(NSArray<JvmaItem*> *)items;

@end
