//
//  JvmaNAKData.h
//  JvmaSDK
//
//  Created by DS.Zhang on 2017/2/13.
//  Copyright © 2017年 MRX_DS.Zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Define.h"
typedef NS_ENUM(NSInteger, JvmaNAKStatus) {
    VmBusy               = 0x01,//JVMA モジュールがビジー状態であることを表す。
    VmStop               = 0x02,//自動販売機から NAK が返送されたことを表す。通信セッションは中止される。
    VmTimeOut            = 0x03,//自動販売機が無応答またはタイムアウトしたことを表す。通信セッションは中止される。
    VmError              = 0x04,//パケット形式または BCC エラーを検出したことを表す。通信セッションは中止される。
    JvmaTimeOut          = 0x05,//ホストと JVMA モジュール間の応答が確認できずタイムアウトしたことを表す。通信セッションは中断される。
    VmBeforeBuildSession = 0x06,//パスワードテキストによる通信セッション確立前に コマンドテキストが送信されたことを表す。
    JvmaDataSend         = 0x07,//コマンドテキストの前にホストからデータテキスト が送信されたことを表す。通信セッションは中断さ れる。
    JvmaOtherDataSend    = 0x08,//データテキストの中継転送中にホストから他のテキ ストが送信されたことを表す。通信セッションは中 断される。
    VmOutResponse        = 0x09,//ホストから応答待ち以外のタイミングで NAK を受信 した。通信セッションは中断される。
    SDKTimeOut           = 0x93,//SDKがAsReaderからの応答を受け取れなく、タイムアウトが発生したことを表す。通信セッションは中止される。
    VmDataClearFailed    = 0x94,//自販機データ収集クリア失敗
    VmOtherError         = 0x99 //その他のエラー。
};
@interface JvmaNAKData : NSObject
@property (nonatomic ,assign, readonly) textHeader nak;
@property (nonatomic ,assign, readonly) JvmaNAKStatus status;
@property (nonatomic, strong, readonly) NSData   *hexData;
@property (nonatomic, strong ,readonly) NSString *hexStatus;
@property (nonatomic, strong, readonly) NSString *nakMessage;

- (instancetype)initWithStatus:(JvmaNAKStatus)status textType:(JvmaTextType)textType;
- (instancetype)initWithData:(NSData *)data textType:(JvmaTextType)textType;;

@end
