//
//  JvmaError.h
//  JvmaSDK
//
//  Created by DS.Zhang on 2017/2/20.
//  Copyright © 2017年 MRX_DS.Zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
typedef NS_ENUM(NSInteger, JvmaErrorCode){
    SettingCodeLengthError            =1001,
    TerminalPasswordLengthError       =1002,
    JvmaItemFormatError               =1003,
    JvmaItemLengthOver                =1004,
    JvmaDataIdCodeNotFound            =1005,
    JvmaItemDigitsNotSame             =1006,
    NotJvmaItemClass                  =1007,
    JvmaItemIsNull                    =1008,
    JvmaItemsIsEmpty                  =1009,
    JvmaRecordDataLengthOver          =1010,
    JvmaRecordDataLengthError         =1011,
    JvmaTextLenghtError               =1012,
    NotJvmaRecordClass                =1013,
    SendDataIsNull                    =1014,
    AsReaderAskIsNull                 =1015,
    AsReaderDisconnected              =1016,
    NotJvmaDataIdClass                =1017,
    ResultDataIsNull                  =1018,
    STXCheckError                     =1019,
    TextTypeCheckError                =1020,
    BCDCheckError                     =1021,
    JvmaRecordIsNull                  =1022,
    JvmaRecordDataIsNull              =1023,
    JvmaDataIdIsNull                  =1024,
    JvmaACKDataError                  =1025,
    JvmaNAKDataError                  =1026,
    TextHeaderTypeError               =1027,
    JvmaItemTotalLengthCheckError     =1028,
    JvmaItemLengthCheckError          =1029,
    ETXOrETBCheckError                =1030,
    BCCCheckError                     =1031,
    OtherError                        =1032
};

@interface JvmaError : NSObject
@property (nonatomic, assign, readonly)JvmaErrorCode errorCode;
@property (nonatomic, strong, readonly)NSString *errorMessage;

- (instancetype)initWithErrorCode:(JvmaErrorCode)errorCode errorClass:(NSString*)errorClass errorLine:(int)errorLine;
@end
