//
//  JvmaACKData.h
//  JvmaSDK
//
//  Created by DS.Zhang on 2017/2/13.
//  Copyright © 2017年 MRX_DS.Zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Define.h"

typedef NS_ENUM(NSInteger, JvmaACKStatus) {
    VmSucceed = 0x00,//通信の肯定応答
    VmStarted = 0x01,//交信開始ステータス
    VmConfirmConnect = 0x02,//接続確立ステータス。
    VmCommandConfirm= 0x03 //コマンド確認ステータス。
};
@interface JvmaACKData : NSObject
@property (nonatomic ,assign, readonly) textHeader ack;
@property (nonatomic ,assign, readonly) JvmaACKStatus status;
@property (nonatomic, strong, readonly) NSData   *hexData;
@property (nonatomic, strong ,readonly) NSString *hexStatus;

- (instancetype)initWithStatus:(JvmaACKStatus)status;
- (instancetype)initWithData:(NSData *)data;
@end
