//
//  BluetoothModule.h
//  JvmaSDK
//
//  Created by ZDS on 2025/4/8.
//  Copyright © 2025 MRX_DS.Zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreBluetooth/CoreBluetooth.h>

NS_ASSUME_NONNULL_BEGIN
@class BluetoothModule;
@protocol BluetoothModuleStatusDelegate <NSObject>
@optional
- (void)onConnected:(BluetoothModule *)bluetoothModule;
- (void)onConnectError:(NSError *)error bluetoothModule:(BluetoothModule *)bluetoothModule;
- (void)onDisconnected:(BluetoothModule *)bluetoothModule;
- (void)onReceivedError:(NSError *)error bluetoothModule:(BluetoothModule *)bluetoothModule;
@end

@protocol BluetoothModuleDataDelegate <NSObject>
@optional
- (void)onReceivedData:(NSData *)data bluetoothModule:(BluetoothModule *)bluetoothModule;
@end

@interface BluetoothModule : NSObject
@property (strong, readonly) NSString *name;
@property (strong, readonly) NSString *identifier;
@property (assign, readonly) BOOL isConnected;

@property (nonatomic, weak) id<BluetoothModuleStatusDelegate> statusDelegate;
@property (nonatomic, weak) id<BluetoothModuleDataDelegate> dataDelegate;

- (instancetype)initWithCentralManager:(CBCentralManager *)central
                            peripheral:(CBPeripheral *)peripheral
                 advertisementData:(NSDictionary<NSString *, id> *)advertisementData
                              RSSI:(NSNumber *)RSSI
                        identifier:(NSString *)identifier;

- (BOOL)sendData:(NSData *)data;
- (void)connect;
- (void)disconnect;

- (BOOL)reConnect;
- (void)onDisconnect;
@end

NS_ASSUME_NONNULL_END
