import 'dart:async';
import 'package:a3xd_plugin/a3xd_plugin.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'event_bus_instance.dart';

class InformationWidget extends StatefulWidget {
  const InformationWidget({super.key});

  @override
  State<StatefulWidget> createState() => InformationState();
}

class InformationState extends State<InformationWidget> {
  final _a3xdPlugin = A3xdPlugin();
   static const iosCallPlatform = MethodChannel('a3xd_plugin');
  static const APP_VERSION = '1.0.0';
  static const APP_BUILD = '1';
  String appv = '';
  String fluttersdkv = '';
  String sdkv = '';
  String model = '';
  String hwv = '';
  String fwv = '';
  String rfidv = '';
  late BuildContext mContext;

  @override
  void initState() {
    super.initState();
    initPlatformState();
  }
  Future<void> initPlatformState() async {
    Future<dynamic> _handler(MethodCall methodCall) {
      print('information methodCall.method:${methodCall.method}, methodCall.arguments:${methodCall.arguments}');
      if (_a3xdPlugin.ON_CONNECT == methodCall.method) {
        bool isConnected = methodCall.arguments['result'];
        print('onConnect:$isConnected');
        connected(isConnected);
      } else if (_a3xdPlugin.ON_READER_ABOUT_INFO == methodCall.method) {
        setState(() {
          model = methodCall.arguments['model'];
          hwv = methodCall.arguments['hwVersion'];
          fwv = methodCall.arguments['fwVersion'];
        });
        print('onReaderAboutInfo:$model' + ' hwv:' + hwv + " fwv:" + fwv);
      } else if (_a3xdPlugin.ON_RECEIVED_RFID_MODULE_VERSION == methodCall.method) {
        setState(() {
          rfidv = methodCall.arguments['result'];
        });
        print('onReceivedRFIDModuleVersion:$model' + ' hwv:' + hwv + " fwv:" +
            fwv);
      } else if (_a3xdPlugin.ON_DEVICE_MANAGER_ERROR == methodCall.method) {
        String error = methodCall.arguments['result'];
        print('onDeviceManagerError:$error');
        onDeviceManagerError(error);
      }
      return Future.value('success');
    }
    iosCallPlatform.setMethodCallHandler(_handler);
    Future.delayed(const Duration(milliseconds: 500), () {
      setState(() {
        getAPPVersion();
        getFlutterSDKVersion();
        getSDKVersion();
        getReaderInfo();
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    mContext = context;
    var container1 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          const Expanded(
            child:Text(
              'APP',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Text(
              appv,
              style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.right,
            ),
          ),
        ],
      ),
    );
    var container7 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          const Expanded(
            child:Text(
              'Flutter SDK',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Text(
              fluttersdkv,
              style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.right,
            ),
          ),
        ],
      ),
    );
    var container2 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          const Expanded(
            child:Text(
              'SDK',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Text(
              sdkv,
              style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.right,
            ),
          ),
        ],
      ),
    );
    var container3 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          const Expanded(
            child:Text(
              'Model',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Text(
              model,
              style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.right,
            ),
          ),
        ],
      ),
    );
    var container4 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          const Expanded(
            child:Text(
              'HW',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Text(
              hwv,
              style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.right,
            ),
          ),
        ],
      ),
    );
    var container5 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          const Expanded(
            child:Text(
              'FW',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Text(
              fwv,
              style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.right,
            ),
          ),
        ],
      ),
    );
    var container6 = Container(
          color: Colors.white,
          padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
            children: <Widget>[
              const Expanded(
                child:Text(
                  'RFID',
                  style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
                  textAlign: TextAlign.left,
                ),
              ),
              Expanded(
                child:Text(
                  rfidv,
                  style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 14.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
                  textAlign: TextAlign.right,
                ),
              ),
            ],
          ),
        );
    return Scaffold(
      appBar: AppBar(
        title: const Text('Information'),
        backgroundColor: Colors.white,
        leading: IconButton(
          icon: Image.asset(
            'images/back.png',
            width: 25,
            height: 25,
            fit: BoxFit.cover,
          ),
          onPressed: () {
            Navigator.pop(context);
          },
        ),
      ),
      body: Container(
        color: Colors.white,
        child: Column(
          children: <Widget>[
            container1,
            container7,
            container2,
            container3,
            container4,
            container5,
            container6,
          ],
        ),
      ),
    );
  }
  void connected(bool isConnected) {
    setState(() {
      if (!isConnected) {
        eventBus.fire(DisconnectEvent());
        Navigator.popUntil(context, ModalRoute.withName('/'));
      }
    });
  }
  void getAPPVersion() {
    setState(() {
      try {
        appv = '$APP_VERSION';
        print('APP version: $appv');
      } on PlatformException {
        appv = '';
        print('Failed to get app version.');
      }
    });
  }

  void getFlutterSDKVersion() {
    setState(() {
      try {
        Future<String?> sdkString = _a3xdPlugin.getA3XDFlutterVersion();
        sdkString.then((futureResult) {
          if (futureResult != null && futureResult.isNotEmpty) {
            fluttersdkv = futureResult;
          } else {
            fluttersdkv = '';
          }
          print('Flutter SDK version: $fluttersdkv');
        });
      } on PlatformException {
        fluttersdkv = '';
        print('Failed to get flutter sdk version.');
      }
    });
  }
  void getSDKVersion() {
    setState(() {
      try {
        Future<String?> sdkString = _a3xdPlugin.getA3XDSDKVersion();
        sdkString.then((futureResult) {
          if (futureResult != null && futureResult.isNotEmpty) {
            sdkv = futureResult;
          } else {
            sdkv = '';
          }
          print('SDK version: $sdkv');
        });
      } on PlatformException {
        sdkv = '';
        print('Failed to get sdk version.');
      }
    });
  }
  void getReaderInfo() {
    setState(() {
      _a3xdPlugin.getReaderInfo(0xb1);
      _a3xdPlugin.getReaderInfo(0x01);
    });
  }
  void onDeviceManagerError(String error) {
    setState(() {
      showAlertDialog(
          mContext, '', error);
    });
  }
  void showAlertDialog(BuildContext context, String title, String message) {
    Widget okButton = ElevatedButton(
      child: const Text('OK'),
      onPressed: () {
        Navigator.of(context).pop();
      },
    );
    AlertDialog alert = AlertDialog(
      title: Text(title),
      content: Text(message),
      actions: [
        okButton,
      ],
    );
    showDialog(
      context: context,
      builder: (BuildContext context) {
        return alert;
      },
    );
  }
}
