import 'package:flutter/foundation.dart';
import 'package:flutter/services.dart';
import 'package:a3xd_plugin/a3xd_define.dart';
import 'a3xd_plugin_platform_interface.dart';

/// An implementation of [A3xdPluginPlatform] that uses method channels.
class MethodChannelA3xdPlugin extends A3xdPluginPlatform {
  /// The method channel used to interact with the native platform.
  @visibleForTesting
  final methodChannel = const MethodChannel('a3xd_plugin');

  @override
  Future<String?> getPlatformVersion() async {
    final version = await methodChannel.invokeMethod<String>(
        'getPlatformVersion');
    return version;
  }

  @override
  Future<String?> getA3XDFlutterVersion() async {
    final version = await methodChannel.invokeMethod<String>(
        'getA3XDFlutterVersion');
    return version;
  }

  @override
  Future<String?> getA3XDSDKVersion() async {
    final version = await methodChannel.invokeMethod<String>(
        'getA3XDSDKVersion');
    return version;
  }

  @override
  Future<void> setLogLevel(A3XDLogLevel level) async {
    await methodChannel.invokeMethod('setLogLevel', {
      'level': level.index,
    });
  }

  @override
  Future<A3XDLogLevel?> getLogLevel() async {
    final level = await methodChannel.invokeMethod<int>('getLogLevel');
    return A3XDLogLevel.values[level!];
  }

  @override
  Future<void> setLog(bool enable) async {
    await methodChannel.invokeMethod('setLog', {
      'enable': enable,
    });
  }

  @override
  Future<void> removeSDKLog() async {
    await methodChannel.invokeMethod('removeSDKLog');
  }

  @override
  Future<bool?> isConnected() async {
    final isConnected = await methodChannel.invokeMethod<String>(
        'isConnected');
    return isConnected.toString() == '1';
  }

  @override
  Future<bool?> isPowerOn() async {
    final isPowerOn = await methodChannel.invokeMethod<String>('isPowerOn');
    return isPowerOn.toString() == '1';
  }

  @override
  Future<bool?> isOpen() async {
    final isOpen = await methodChannel.invokeMethod<String>('isOpen');
    return isOpen.toString() == '1';
  }

  @override
  Future<void> setPower(bool enable) async {
    await methodChannel.invokeMethod('setPower', {
      'enable': enable,
    });
  }

  @override
  Future<void> setPowerWithOption(bool power, bool beep, bool vib,
      bool led, bool aimer, bool powerOnBeep) async {
    await methodChannel.invokeMethod('setPowerWithOption', {
      'power': power,
      'beep': beep,
      'vib': vib,
      'led': led,
      'aimer': aimer,
      'powerOnBeep': powerOnBeep,
    });
  }

  @override
  Future<void> setReaderSettings(bool beep, bool vib, bool led,
      bool aimer) async {
    await methodChannel.invokeMethod('setReaderSettings', {
      'beep': beep,
      'vib': vib,
      'led': led,
      'aimer': aimer,
    });
  }

  @override
  Future<void> getBattery() async {
    await methodChannel.invokeMethod('getBattery');
  }

  @override
  Future<void> getReaderInfo(int type) async {
    await methodChannel.invokeMethod('getReaderInfo', {
      'type': type,
    });
  }

  @override
  Future<bool?> isM30SDevice() async {
    final isM30SDevice = await methodChannel.invokeMethod<String>(
        'isM30SDevice');
    return isM30SDevice.toString() == '1';
  }

  @override
  Future<void> setMaxTagValue(int value) async {
    await methodChannel.invokeMethod('setMaxTagValue', {
      'value': value,
    });
  }

  @override
  Future<int?> getMaxTagValue() async {
    final value = await methodChannel.invokeMethod<int>('getMaxTagValue');
    return value;
  }

  @override
  Future<void> setMaxTimeValue(int value) async {
    await methodChannel.invokeMethod('setMaxTimeValue', {
      'value': value,
    });
  }

  @override
  Future<int?> getMaxTimeValue() async {
    final value = await methodChannel.invokeMethod<int>('getMaxTimeValue');
    return value;
  }

  @override
  Future<void> setRepeatCycleValue(int value) async {
    await methodChannel.invokeMethod('setRepeatCycleValue', {
      'value': value,
    });
  }

  @override
  Future<int?> getRepeatCycleValue() async {
    final value = await methodChannel.invokeMethod<int>('getRepeatCycleValue');
    return value;
  }

  @override
  Future<void> setRSSIEnable(bool enable) async {
    await methodChannel.invokeMethod('setRSSIEnable', {
      'enable': enable,
    });
  }

  @override
  Future<bool?> getRSSIEnable() async {
    final value = await methodChannel.invokeMethod<String>('getRSSIEnable');
    return value.toString() == '1';
  }

  @override
  Future<void> startInventory(int maxTags, int maxTime, int repeatCycle) async {
    await methodChannel.invokeMethod('startInventory', {
      'maxTags': maxTags,
      'maxTime': maxTime,
      'repeatCycle': repeatCycle,
    });
  }

  @override
  Future<void> startInventoryRSSI(int maxTags, int maxTime,
      int repeatCycle) async {
    await methodChannel.invokeMethod('startInventoryRSSI', {
      'maxTags': maxTags,
      'maxTime': maxTime,
      'repeatCycle': repeatCycle,
    });
  }

  @override
  Future<void> startInventoryTagID(int maxTags, int maxTime,
      int repeatCycle) async {
    await methodChannel.invokeMethod('startInventoryTagID', {
      'maxTags': maxTags,
      'maxTime': maxTime,
      'repeatCycle': repeatCycle,
    });
  }

  @override
  Future<void> startRFMDecode(int codeType, int maxTags, int maxTime,
      int repeatCycle) async {
    await methodChannel.invokeMethod('startRFMDecode', {
      'codeType': codeType,
      'maxTags': maxTags,
      'maxTime': maxTime,
      'repeatCycle': repeatCycle,
    });
  }

  @override
  Future<void> stopDecode() async {
    await methodChannel.invokeMethod('stopDecode');
  }

  @override
  Future<void> setRegion(int region) async {
    await methodChannel.invokeMethod('setRegion', {
      'region': region,
    });
  }

  @override
  Future<void> getRegion() async {
    await methodChannel.invokeMethod('getRegion');
  }

  @override
  Future<void> setSmartHopping(bool isOn) async {
    await methodChannel.invokeMethod('setSmartHopping', {
      'isOn': isOn,
    });
  }

  @override
  Future<void> getFrequencyHoppingMode() async {
    await methodChannel.invokeMethod('getFrequencyHoppingMode');
  }

  @override
  Future<void> setOptimumFrequencyHoppingTable() async {
    await methodChannel.invokeMethod('setOptimumFrequencyHoppingTable');
  }

  @override
  Future<void> getFrequencyHoppingTable() async {
    await methodChannel.invokeMethod('getFrequencyHoppingTable');
  }

  @override
  Future<void> setChannel(int num, int offset) async {
    await methodChannel.invokeMethod('setChannel', {
      'num': num,
      'offset': offset,
    });
  }

  @override
  Future<void> getChannel() async {
    await methodChannel.invokeMethod('getChannel');
  }

  @override
  Future<void> setSession(int session) async {
    await methodChannel.invokeMethod('setSession', {
      'session': session,
    });
  }

  @override
  Future<void> getSession() async {
    await methodChannel.invokeMethod('getSession');
  }

  @override
  Future<void> setAntiCollisionMode(int mode, int start, int max, int min,
      int counter) async {
    await methodChannel.invokeMethod('setAntiCollisionMode', {
      'mode': mode,
      'start': start,
      'max': max,
      'min': min,
      'counter': counter,
    });
  }

  @override
  Future<void> getAntiCollisionMode() async {
    await methodChannel.invokeMethod('getAntiCollisionMode');
  }

  @override
  Future<void> setFhLbtParam(int readTime, int idleTime, int senseTime,
      int rfLevel, int fhMode, int lbtMode, int cwMode) async {
    await methodChannel.invokeMethod('setFhLbtParam', {
      'readTime': readTime,
      'idleTime': idleTime,
      'senseTime': senseTime,
      'rfLevel': rfLevel,
      'fhMode': fhMode,
      'lbtMode': lbtMode,
      'cwMode': cwMode,
    });
  }

  @override
  Future<void> getFhLbtParam() async {
    await methodChannel.invokeMethod('getFhLbtParam');
  }

  @override
  Future<void> setOutputPowerLevel(int level) async {
    await methodChannel.invokeMethod('setOutputPowerLevel', {
      'level': level,
    });
  }

  @override
  Future<void> getOutputPowerLevel() async {
    await methodChannel.invokeMethod('getOutputPowerLevel');
  }

  @override
  Future<void> setModulation(String mode) async {
    await methodChannel.invokeMethod('setModulation', {
      'mode': mode,
    });
  }

  @override
  Future<void> getModulation() async {
    await methodChannel.invokeMethod('getModulation');
  }

  @override
  Future<void> setTriggerStopCondition(int maxTags, int maxTime,
      int repeatCycle) async {
    await methodChannel.invokeMethod('setTriggerStopCondition', {
      'maxTags': maxTags,
      'maxTime': maxTime,
      'repeatCycle': repeatCycle,
    });
  }

  @override
  Future<void> readTagMemory(int password, String targetEPC,
      A3XDMemoryBank memoryBank, A3XDReadMemoryType readType) async {
    await methodChannel.invokeMethod('readTagMemory', {
      'password': password,
      'targetEPC': targetEPC,
      'memoryBank': memoryBank.index,
      'readType': readType.index,
    });
  }

  @override
  Future<void> readTagMemoryWithTimeout(int password, String targetEPC,
      A3XDMemoryBank memoryBank, A3XDReadMemoryType readType,
      int timeout) async {
    await methodChannel.invokeMethod('readTagMemoryWithTimeout', {
      'password': password,
      'targetEPC': targetEPC,
      'memoryBank': memoryBank.index,
      'readType': readType.index,
      'timeout': timeout,
    });
  }

  @override
  Future<void> readTagMemoryWithData(int password, String targetEPC,
      A3XDMemoryBank memoryBank, A3XDReadMemoryType readType, int startAddress,
      int dataLength, int timeout) async {
    await methodChannel.invokeMethod('readTagMemoryWithData', {
      'password': password,
      'targetEPC': targetEPC,
      'memoryBank': memoryBank.index,
      'readType': readType.index,
      'startAddress': startAddress,
      'dataLength': dataLength,
      'timeout': timeout,
    });
  }

  @override
  Future<void> writeTagMemory(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDWriteMemoryType writeType, Uint8List writeData) async {
      await methodChannel.invokeMethod('writeTagMemory', {
      'password': password,
      'targetEPC': targetEPC,
      'memoryBank': memoryBank.index,
      'writeType': writeType.index,
      'writeData': writeData,
      });
  }

  @override
  Future<void> writeTagMemoryWithTimeout(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDWriteMemoryType writeType, Uint8List writeData, int timeout) async {
      await methodChannel.invokeMethod('writeTagMemoryWithTimeout', {
      'password': password,
      'targetEPC': targetEPC,
      'memoryBank': memoryBank.index,
      'writeType': writeType.index,
      'writeData': writeData,
      'timeout': timeout,
      });
  }

  @override
  Future<void> writeTagMemoryWithData(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDWriteMemoryType writeType, int startAddress, Uint8List writeData, int timeout) async {
      await methodChannel.invokeMethod('writeTagMemoryWithData', {
      'password': password,
      'targetEPC': targetEPC,
      'memoryBank': memoryBank.index,
      'writeType': writeType.index,
      'startAddress': startAddress,
      'writeData': writeData,
      'timeout': timeout,
      });
  }

  @override
  Future<void> killTag(int password, String targetEPC) async {
      await methodChannel.invokeMethod('killTag', {
      'password': password,
      'targetEPC': targetEPC,
      });
  }

  @override
  Future<void> lockTagMemory(int password, String targetEPC, int lockData) async {
      await methodChannel.invokeMethod('lockTagMemory', {
      'password': password,
      'targetEPC': targetEPC,
      'lockData': lockData,
      });
  }

  @override
  Future<void> lockTagMemoryWithTimeout(int password, String targetEPC, int lockData, int timeout) async {
      await methodChannel.invokeMethod('lockTagMemoryWithTimeout', {
      'password': password,
      'targetEPC': targetEPC,
      'lockData': lockData,
      'timeout': timeout,
      });
  }

  @override
  Future<void> updateRegistry() async {
      await methodChannel.invokeMethod('updateRegistry');
  }

  @override
  Future<void> getContinuousMode() async {
      await methodChannel.invokeMethod('getContinuousMode');
  }

  @override
  Future<void> setContinuousMode(bool isOn) async {
      await methodChannel.invokeMethod('setContinuousMode', {
        'isOn': isOn,
      });
  }

  @override
  Future<void> getAutoOffTime() async {
      await methodChannel.invokeMethod('getAutoOffTime');
  }

  @override
  Future<void> setAutoOffTime(int time) async {
      await methodChannel.invokeMethod('setAutoOffTime', {
        'time': time,
      });
  }

  @override
  Future<void> getSessionFlag() async {
      await methodChannel.invokeMethod('getSessionFlag');
  }

  @override
  Future<void> setSessionFlag(int sessionFlag) async {
      await methodChannel.invokeMethod('setSessionFlag', {
        'sessionFlag': sessionFlag,
      });
  }

  @override
  Future<void> getQValue() async {
      await methodChannel.invokeMethod('getQValue');
  }

  @override
  Future<void> setQValue(int value) async {
      await methodChannel.invokeMethod('setQValue', {
        'value': value,
      });
  }

  @override
  Future<void> getHidMode() async {
      await methodChannel.invokeMethod('getHidMode');
  }

  @override
  Future<void> setHidMode(bool hidMode) async {
      await methodChannel.invokeMethod('setHidMode', {
        'hidMode': hidMode,
      });
  }

  @override
  Future<void> getDutyRatio() async {
      await methodChannel.invokeMethod('getDutyRatio');
  }

  @override
  Future<void> setDutyRatio(int dutyRatio) async {
      await methodChannel.invokeMethod('setDutyRatio', {
        'dutyRatio': dutyRatio,
      });
  }

 @override
  Future<void> getDutyRatioBaseTime() async {
      await methodChannel.invokeMethod('getDutyRatioBaseTime');
  }

  @override
  Future<void> setDutyRatioBaseTime(int dutyRatioBaseTime) async {
      await methodChannel.invokeMethod('setDutyRatioBaseTime', {
        'dutyRatioBaseTime': dutyRatioBaseTime,
      });
  }
}