/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk.manager.communication;

import android.content.Context;
import jp.co.asterisk.asreader.a3xd.sdk.PacketParser;
import jp.co.asterisk.asreader.a3xd.sdk.manager.USBManager;
import jp.co.asterisk.asreader.a3xd.sdk.manager.USBManagerCallback;
import jp.co.asterisk.asreader.a3xd.sdk.manager.communication.CommunicationManagerDeviceCallback;
import jp.co.asterisk.asreader.a3xd.sdk.manager.communication.CommunicationManagerRFIDCallback;
import jp.co.asterisk.asreader.a3xd.sdk.utility.LogLevel;
import jp.co.asterisk.asreader.a3xd.sdk.utility.PacketModel;
import jp.co.asterisk.asreader.a3xd.sdk.utility.SDKLog;

public class CommunicationManager
implements USBManagerCallback {
    private static CommunicationManager instance;
    private final String TAG = CommunicationManager.class.getSimpleName();
    private CommunicationManagerDeviceCallback deviceCallback;
    private CommunicationManagerRFIDCallback rfidCallback;

    public void setDeviceCallBack(CommunicationManagerDeviceCallback callback) {
        this.deviceCallback = callback;
    }

    public void setRFIDCallBack(CommunicationManagerRFIDCallback callback) {
        this.rfidCallback = callback;
    }

    private CommunicationManager() {
    }

    public static CommunicationManager getInstance() {
        if (instance == null) {
            instance = new CommunicationManager();
        }
        return instance;
    }

    public void initialize(Context context) {
        USBManager.getInstance().setCallback(this);
        USBManager.getInstance().initialize(context);
    }

    public boolean isOpen() {
        return USBManager.getInstance().isOpen();
    }

    public void open() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "CommunicationManager open");
        USBManager.getInstance().open();
    }

    public void close() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "CommunicationManager close");
        USBManager.getInstance().close();
    }

    public boolean sendPacket(PacketModel packetModel) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "CommunicationManager sendPacket");
        packetModel.makeCRC();
        return USBManager.getInstance().sendData(packetModel.toByteArray());
    }

    public boolean sendData(byte[] buffer) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "CommunicationManager sendData");
        return USBManager.getInstance().sendData(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzedPacketData(PacketModel packetModel) {
        CommunicationManager communicationManager = this;
        synchronized (communicationManager) {
            if (packetModel == null) {
                return;
            }
            switch (packetModel.getCommand()) {
                case -126: 
                case -46: 
                case -28: 
                case -27: 
                case -26: 
                case 6: 
                case 7: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 34: 
                case 35: 
                case 41: 
                case 42: 
                case 46: 
                case 47: 
                case 48: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 59: 
                case 70: 
                case 101: {
                    this.rfidCallback.onReceivedData(packetModel);
                    break;
                }
                case -85: 
                case -35: 
                case -30: 
                case -1: 
                case 1: 
                case 3: {
                    this.deviceCallback.onReceivedData(packetModel);
                }
            }
        }
    }

    @Override
    public void onReceivedData(byte[] data) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "CommunicationManager onReceivedData ");
        PacketParser.getInstance().parse(data);
    }
}

