/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk;

import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.CheckPacketState;
import jp.co.asterisk.asreader.a3xd.sdk.ErrorMessage;
import jp.co.asterisk.asreader.a3xd.sdk.SharedPreferencesHelper;
import jp.co.asterisk.asreader.a3xd.sdk.manager.DeviceManagerCallback;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;
import jp.co.asterisk.asreader.a3xd.sdk.manager.USBManager;
import jp.co.asterisk.asreader.a3xd.sdk.manager.communication.CommunicationManager;
import jp.co.asterisk.asreader.a3xd.sdk.utility.CRCCalculator;
import jp.co.asterisk.asreader.a3xd.sdk.utility.LogLevel;
import jp.co.asterisk.asreader.a3xd.sdk.utility.PacketModel;
import jp.co.asterisk.asreader.a3xd.sdk.utility.SDKLog;

public class PacketParser {
    private static PacketParser instance;
    private long checkedTime = System.currentTimeMillis();
    private CheckPacketState packetState = CheckPacketState.START;
    private List<Byte> packetArray = new ArrayList<Byte>();
    private int payloadLength = 0;
    private int payloadCount = 0;
    private DeviceManagerCallback deviceManagerCallback;
    private RFIDManagerCallback rfidManagerCallback;
    private String hwVersion = "";
    private String fwVersion = "";
    private int region = 0;
    private int power = 0;
    private int powerMin = 0;
    private int powerMax = 0;

    private PacketParser() {
    }

    public static PacketParser getInstance() {
        if (instance == null) {
            instance = new PacketParser();
        }
        return instance;
    }

    public void setDeviceManagerCallback(DeviceManagerCallback callback) {
        this.deviceManagerCallback = callback;
    }

    public void setRFIDManagerCallback(RFIDManagerCallback callback) {
        this.rfidManagerCallback = callback;
    }

    public PacketModel parse(byte[] data) {
        if (USBManager.getInstance().isM30SDevice()) {
            try {
                this.decodeM30SData(data);
            }
            catch (Exception e) {
                SDKLog.getInstance().Log("==", LogLevel.Error, "catch: " + e.toString());
            }
        } else {
            this.checkPacket(data);
        }
        return null;
    }

    public void decodeM30SData(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            sb.append(String.format("%02X ", data[i]));
        }
        SDKLog.getInstance().Log("==", LogLevel.Information, "sb: " + sb.toString());
        if (data[0] == 126) {
            if ((data[data.length - 2] & 0xFF) != 13 || (data[data.length - 1] & 0xFF) != 10) {
                SDKLog.getInstance().Log("==", LogLevel.Information, "error data return.");
                return;
            }
            block0 : switch (data[1] & 0xFF) {
                case 101: {
                    switch (data[2] & 0xFF) {
                        case 66: {
                            int maxTag = SharedPreferencesHelper.getInstance().getMaxTag();
                            int maxTime = SharedPreferencesHelper.getInstance().getMaxTime();
                            int repeatCycle = SharedPreferencesHelper.getInstance().getRepeatCycle();
                            boolean rssi = SharedPreferencesHelper.getInstance().getRssi();
                            if ((data[5] & 0xFF) == 49) {
                                Log.d((String)"==", (String)"\u6309\u4e0b");
                                if (rssi) {
                                    AsReaderSDK.getInstance().getRFIDManager().startInventoryRSSI(maxTag, maxTime, repeatCycle);
                                    break block0;
                                }
                                AsReaderSDK.getInstance().getRFIDManager().startInventory(maxTag, maxTime, repeatCycle);
                                break block0;
                            }
                            Log.d((String)"==", (String)"\u62ac\u8d77");
                            AsReaderSDK.getInstance().getRFIDManager().stopDecode();
                            break block0;
                        }
                        case 84: {
                            int length = data[3] & 0xFF;
                            if (length + 7 != data.length || (data[data.length - 2] & 0xFF) != 13 || (data[data.length - 1] & 0xFF) != 10) {
                                SDKLog.getInstance().Log("==Error ", LogLevel.Information, "Receive data read: [RX] " + sb.toString());
                                return;
                            }
                            SDKLog.getInstance().Log("==", LogLevel.Information, "Receive data read: [RX] " + sb.toString());
                            int ant = data[4] & 0xFF;
                            byte[] pc = new byte[]{(byte)(data[5] & 0xFF), (byte)(data[6] & 0xFF)};
                            int epcLength = (pc[0] & 0xFF & 0xF8) >> 3;
                            byte[] epc = new byte[epcLength * 2];
                            System.arraycopy(data, 7, epc, 0, epcLength * 2);
                            byte[] pcEPC = this.concat(pc, epc);
                            int[] intData = new int[pcEPC.length];
                            for (int i = 0; i < pcEPC.length; ++i) {
                                intData[i] = pcEPC[i] & 0xFF;
                            }
                            int rssi = 0;
                            int rssiStatus = data[6 + epcLength * 2 + 1] & 0xFF;
                            if (rssiStatus == 161) {
                                byte[] rssiData = new byte[4];
                                System.arraycopy(data, 6 + epcLength * 2 + 2, rssiData, 0, 4);
                                ByteBuffer byteBuffer = ByteBuffer.wrap(rssiData);
                                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                                float rssiThreshold = byteBuffer.getFloat();
                                rssi = (int)rssiThreshold;
                            }
                            if (AsReaderSDK.getInstance().getRFIDManager().getRSSIEnable()) {
                                this.rfidManagerCallback.onTagWithRssiReceived(intData, rssi);
                                break block0;
                            }
                            this.rfidManagerCallback.onTagReceived(intData);
                            break block0;
                        }
                    }
                    break;
                }
                case 82: {
                    switch (data[2] & 0xFF) {
                        case 97: {
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"power range");
                            StringBuilder stringBuilder = new StringBuilder();
                            boolean isPowerMax = false;
                            for (int i = 7; i < data.length - 2; ++i) {
                                if (isPowerMax) {
                                    stringBuilder.append((char)data[i]);
                                    this.powerMax = Integer.parseInt(stringBuilder.toString());
                                    continue;
                                }
                                if ((data[i] & 0xFF) == 44) {
                                    isPowerMax = true;
                                    stringBuilder = new StringBuilder();
                                    continue;
                                }
                                stringBuilder.append((char)data[i]);
                                this.powerMin = Integer.parseInt(stringBuilder.toString());
                            }
                            break block0;
                        }
                        case 112: {
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"power ");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 7; i < data.length - 2; ++i) {
                                stringBuilder.append((char)data[i]);
                            }
                            this.power = Integer.parseInt(stringBuilder.toString());
                            this.deviceManagerCallback.onReaderInfoReceived(0, 0, 0, 0, 0, 0, 0, this.power, this.powerMin, this.powerMax);
                            this.rfidManagerCallback.onTxPowerLevelReceived(this.power, this.powerMin, this.powerMax);
                            break;
                        }
                        case 103: {
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"region ");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 7; i < data.length - 2; ++i) {
                                stringBuilder.append((char)data[i]);
                            }
                            this.region = Integer.parseInt(stringBuilder.toString());
                            switch (this.region) {
                                case 0: {
                                    this.region = 17;
                                    break;
                                }
                                case 1: {
                                    this.region = 49;
                                    break;
                                }
                                case 2: {
                                    this.region = 33;
                                    break;
                                }
                                case 3: {
                                    this.region = 81;
                                    break;
                                }
                                case 5: {
                                    this.region = 97;
                                    break;
                                }
                                case 8: {
                                    this.region = 65;
                                }
                            }
                            this.rfidManagerCallback.onRegionReceived(this.region);
                            this.deviceManagerCallback.onReaderAboutInfo("ASR-M30S", this.hwVersion, this.fwVersion, (byte)this.region);
                            break;
                        }
                        case 86: {
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"RFIDModuleVersion ");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 7; i < data.length - 2; ++i) {
                                stringBuilder.append((char)data[i]);
                            }
                            this.deviceManagerCallback.onReceivedRFIDModuleVersion(stringBuilder.toString());
                            break;
                        }
                        case 118: {
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"fwVersion ");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 7; i < data.length - 2; ++i) {
                                stringBuilder.append((char)data[i]);
                            }
                            this.fwVersion = stringBuilder.toString();
                            break;
                        }
                        case 72: {
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"hwVersion ");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 7; i < data.length - 2; ++i) {
                                stringBuilder.append((char)data[i]);
                            }
                            this.hwVersion = stringBuilder.toString();
                            break;
                        }
                        case 115: {
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"session ");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 7; i < data.length - 2; ++i) {
                                stringBuilder.append((char)data[i]);
                            }
                            int session = Integer.parseInt(stringBuilder.toString());
                            this.rfidManagerCallback.onSessionReceived(session);
                            break;
                        }
                        case 52: {
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"link_profile");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 7; i < data.length - 2; ++i) {
                                stringBuilder.append((char)data[i]);
                            }
                            int linkProfile = Integer.parseInt(stringBuilder.toString());
                            int blf = 640;
                            int rxMod = 3;
                            int dr = 2;
                            if (linkProfile == 0) {
                                blf = 640;
                                rxMod = 3;
                                dr = 2;
                            } else if (linkProfile == 1) {
                                blf = 320;
                                rxMod = 2;
                                dr = 2;
                            } else if (linkProfile == 2) {
                                blf = 250;
                                rxMod = 2;
                                dr = 2;
                            } else if (linkProfile == 3) {
                                blf = 250;
                                rxMod = 1;
                                dr = 2;
                            } else if (linkProfile == 4) {
                                blf = 250;
                                rxMod = 1;
                                dr = 1;
                            }
                            String blfStr = "";
                            String rxModStr = "";
                            String drStr = "";
                            if (blf == 250) {
                                blfStr = "320KHz";
                            } else if (blf == 320) {
                                blfStr = "250KHz";
                            } else if (blf == 640) {
                                blfStr = "160KHz";
                            }
                            if (rxMod == 1) {
                                rxModStr = "M2";
                            } else if (rxMod == 2) {
                                rxModStr = "M4";
                            } else if (rxMod == 3) {
                                rxModStr = "M8";
                            }
                            if (dr == 1) {
                                drStr = "Tari=15us";
                            } else if (dr == 2) {
                                drStr = "Tari=20us";
                            }
                            String currentModulation = blfStr + ", " + rxModStr + ", " + drStr;
                            this.rfidManagerCallback.onModulationReceived(currentModulation);
                            break;
                        }
                        case 99: {
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"continuous mode");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 7; i < data.length - 2; ++i) {
                                stringBuilder.append((char)data[i]);
                            }
                            int continuousMode = Integer.parseInt(stringBuilder.toString());
                            boolean mode = continuousMode != 0;
                            this.rfidManagerCallback.onReceiveContinuousMode(mode);
                            break;
                        }
                        case 116: {
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"auto off time");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 7; i < data.length - 2; ++i) {
                                stringBuilder.append((char)data[i]);
                            }
                            int autoOffTime = Integer.parseInt(stringBuilder.toString());
                            this.rfidManagerCallback.onReceiveAutoOffTime(autoOffTime);
                            break;
                        }
                        case 102: {
                            int i;
                            if (this.checkBytes(data, 3)) {
                                Log.d((String)"==", (String)"session flag");
                                StringBuilder stringBuilder = new StringBuilder();
                                for (i = 7; i < data.length - 2; ++i) {
                                    stringBuilder.append((char)data[i]);
                                }
                                int sessionFlag = Integer.parseInt(stringBuilder.toString());
                                this.rfidManagerCallback.onReceiveSessionFlag(sessionFlag);
                            }
                        }
                        case 81: {
                            int i;
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"Q value");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (i = 7; i < data.length - 2; ++i) {
                                stringBuilder.append((char)data[i]);
                            }
                            int q = Integer.parseInt(stringBuilder.toString());
                            this.rfidManagerCallback.onReceiveQValue(q);
                            break;
                        }
                        case 6: {
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"HID mode");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 7; i < data.length - 2; ++i) {
                                stringBuilder.append((char)data[i]);
                            }
                            int hidMode = Integer.parseInt(stringBuilder.toString());
                            boolean mode = hidMode != 0;
                            this.rfidManagerCallback.onReceiveHidMode(mode);
                            break;
                        }
                        case 4: {
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"duty Ratio");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 7; i < data.length - 2; ++i) {
                                stringBuilder.append((char)data[i]);
                            }
                            int dutyRatio = Integer.parseInt(stringBuilder.toString());
                            this.rfidManagerCallback.onReceiveDutyRatio(dutyRatio);
                            break;
                        }
                        case 5: {
                            if (!this.checkBytes(data, 3)) break;
                            Log.d((String)"==", (String)"duty ratio base time");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 7; i < data.length - 2; ++i) {
                                stringBuilder.append((char)data[i]);
                            }
                            int dutyRatioBaseTime = Integer.parseInt(stringBuilder.toString());
                            this.rfidManagerCallback.onReceiveDutyRatioBaseTime(dutyRatioBaseTime);
                            break;
                        }
                    }
                    break;
                }
                case 87: {
                    switch (data[2] & 0xFF) {
                        case 112: {
                            if (!this.checkBytes(data, 3)) break block0;
                            this.rfidManagerCallback.onSetOutputPowerLevelSuccess();
                            break block0;
                        }
                        case 98: {
                            if (!this.checkBytes(data, 3)) break block0;
                            this.deviceManagerCallback.onSetReaderSettingSuccess();
                            break block0;
                        }
                        case 115: {
                            if (!this.checkBytes(data, 3)) break block0;
                            this.rfidManagerCallback.onSetSessionSuccess();
                            break block0;
                        }
                        case 52: {
                            if (this.checkBytes(data, 3)) {
                                this.rfidManagerCallback.didSetModulation(0);
                                break block0;
                            }
                            this.rfidManagerCallback.didSetModulation(1);
                            break block0;
                        }
                        case 99: {
                            if (this.checkBytes(data, 3)) {
                                this.rfidManagerCallback.didSetContinuousMode(0);
                                break block0;
                            }
                            this.rfidManagerCallback.didSetContinuousMode(1);
                            break block0;
                        }
                        case 116: {
                            Log.d((String)"==", (String)"auto off time");
                            if (this.checkBytes(data, 3)) {
                                this.rfidManagerCallback.didSetAutoOffTime(0);
                                break block0;
                            }
                            this.rfidManagerCallback.didSetAutoOffTime(1);
                            break block0;
                        }
                        case 102: {
                            Log.d((String)"==", (String)"session flag");
                            if (this.checkBytes(data, 3)) {
                                this.rfidManagerCallback.didSetSessionFlag(0);
                                break block0;
                            }
                            this.rfidManagerCallback.didSetSessionFlag(1);
                            break block0;
                        }
                        case 81: {
                            Log.d((String)"==", (String)"Q value");
                            if (this.checkBytes(data, 3)) {
                                this.rfidManagerCallback.didSetQValue(0);
                                break block0;
                            }
                            this.rfidManagerCallback.didSetQValue(1);
                            break block0;
                        }
                        case 6: {
                            Log.d((String)"==", (String)"HID mode");
                            if (this.checkBytes(data, 3)) {
                                this.rfidManagerCallback.didSetHidMode(0);
                                break block0;
                            }
                            this.rfidManagerCallback.didSetHidMode(1);
                            break block0;
                        }
                        case 4: {
                            Log.d((String)"==", (String)"duty Ratio");
                            if (this.checkBytes(data, 3)) {
                                this.rfidManagerCallback.didSetDutyRatio(0);
                                break block0;
                            }
                            this.rfidManagerCallback.didSetDutyRatio(1);
                            break block0;
                        }
                        case 5: {
                            Log.d((String)"==", (String)"duty Ratio base tiem");
                            if (this.checkBytes(data, 3)) {
                                this.rfidManagerCallback.didSetDutyRatioBaseTime(0);
                                break block0;
                            }
                            this.rfidManagerCallback.didSetDutyRatioBaseTime(1);
                            break block0;
                        }
                    }
                    break;
                }
                case 65: {
                    switch (data[2] & 0xFF) {
                        case 108: {
                            if (this.checkBytes(data, 5)) {
                                this.rfidManagerCallback.onLockTagMemorySuccess();
                                break block0;
                            }
                            byte[] code = this.getBytesFromByteArray(data, 5, 4);
                            int newByte = 0;
                            if (this.bytesToAscii(code).equals("F201")) {
                                newByte = 252;
                            } else if (this.bytesToAscii(code).equals("F202")) {
                                newByte = 226;
                            } else if (this.bytesToAscii(code).equals("F203")) {
                                newByte = 226;
                            } else if (this.bytesToAscii(code).equals("F204")) {
                                newByte = 144;
                            } else if (this.bytesToAscii(code).equals("F205")) {
                                newByte = 11;
                            } else if (this.bytesToAscii(code).equals("F206")) {
                                newByte = 3;
                            } else if (this.bytesToAscii(code).equals("F207")) {
                                newByte = 4;
                            } else if (this.bytesToAscii(code).equals("F208")) {
                                newByte = 130;
                            } else if (this.bytesToAscii(code).equals("F209")) {
                                newByte = 240;
                            } else if (this.bytesToAscii(code).equals("F210")) {
                                newByte = 128;
                            } else if (this.bytesToAscii(code).equals("F211")) {
                                newByte = 225;
                            }
                            String message = ErrorMessage.errorMsgType(newByte);
                            this.deviceManagerCallback.onDeviceManagerError(message);
                            break block0;
                        }
                        case 107: {
                            if (this.checkBytes(data, 5)) {
                                this.rfidManagerCallback.onKillTagMemorySuccess();
                                break block0;
                            }
                            byte[] code = this.getBytesFromByteArray(data, 5, 4);
                            int newByte = 0;
                            if (this.bytesToAscii(code).equals("F301")) {
                                newByte = 252;
                            } else if (this.bytesToAscii(code).equals("F302")) {
                                newByte = 226;
                            } else if (this.bytesToAscii(code).equals("F303")) {
                                newByte = 144;
                            } else if (this.bytesToAscii(code).equals("F304")) {
                                newByte = 11;
                            } else if (this.bytesToAscii(code).equals("F305")) {
                                newByte = 130;
                            } else if (this.bytesToAscii(code).equals("F306")) {
                                newByte = 240;
                            } else if (this.bytesToAscii(code).equals("F307")) {
                                newByte = 128;
                            }
                            String message = ErrorMessage.errorMsgType(newByte);
                            this.deviceManagerCallback.onDeviceManagerError(message);
                            break block0;
                        }
                        case 119: {
                            if (this.checkBytes(data, 5)) {
                                this.rfidManagerCallback.onWriteToTagMemorySuccess();
                                break block0;
                            }
                            byte[] code = this.getBytesFromByteArray(data, 5, 4);
                            int newByte = 0;
                            if (this.bytesToAscii(code).equals("F101")) {
                                newByte = 252;
                            } else if (this.bytesToAscii(code).equals("F102")) {
                                newByte = 226;
                            } else if (this.bytesToAscii(code).equals("F103")) {
                                newByte = 226;
                            } else if (this.bytesToAscii(code).equals("F104")) {
                                newByte = 144;
                            } else if (this.bytesToAscii(code).equals("F105")) {
                                newByte = 11;
                            } else if (this.bytesToAscii(code).equals("F106")) {
                                newByte = 3;
                            } else if (this.bytesToAscii(code).equals("F107")) {
                                newByte = 4;
                            } else if (this.bytesToAscii(code).equals("F108")) {
                                newByte = 130;
                            } else if (this.bytesToAscii(code).equals("F109")) {
                                newByte = 240;
                            } else if (this.bytesToAscii(code).equals("F110")) {
                                newByte = 128;
                            } else if (this.bytesToAscii(code).equals("F111")) {
                                newByte = 225;
                            }
                            String message = ErrorMessage.errorMsgType(newByte);
                            this.deviceManagerCallback.onDeviceManagerError(message);
                            break block0;
                        }
                        case 114: {
                            if (this.checkBytes(data, 5)) {
                                int total = data[3] & 0xFF;
                                int machLength = (((data[9] & 0xFF) << 8 & 0xFF00) + (data[10] & 0xFF)) / 8;
                                byte[] machData = this.getBytesFromByteArray(data, 11, machLength);
                                int readLength = ((data[11 + machLength] & 0xFF) << 8 & 0xFF00) + (data[11 + machLength + 1] & 0xFF);
                                byte[] readData = this.getBytesFromByteArray(data, 11 + machLength + 1 + 1, readLength);
                                int[] resultData = new int[readData.length];
                                for (int i = 0; i < readData.length; ++i) {
                                    resultData[i] = readData[i] & 0xFF;
                                }
                                this.rfidManagerCallback.onTagMemoryReceived(resultData);
                                break block0;
                            }
                            byte[] code = this.getBytesFromByteArray(data, 5, 4);
                            int newByte = 0;
                            if (this.bytesToAscii(code).equals("F001")) {
                                newByte = 128;
                            } else if (this.bytesToAscii(code).equals("F002")) {
                                newByte = 144;
                            } else if (this.bytesToAscii(code).equals("F003")) {
                                newByte = 4;
                            } else if (this.bytesToAscii(code).equals("F004")) {
                                newByte = 3;
                            } else if (this.bytesToAscii(code).equals("F005")) {
                                newByte = 130;
                            } else if (this.bytesToAscii(code).equals("F006")) {
                                newByte = 240;
                            } else if (this.bytesToAscii(code).equals("F007")) {
                                newByte = 225;
                            }
                            String message = ErrorMessage.errorMsgType(newByte);
                            this.deviceManagerCallback.onDeviceManagerError(message);
                            break block0;
                        }
                        case 115: {
                            if (!this.checkBytes(data, 3)) break block0;
                            this.rfidManagerCallback.onAutoInventoryFinished();
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
    }

    public boolean checkBytes(byte[] byteArray, int startIndex) {
        if (byteArray == null || byteArray.length < 7) {
            return false;
        }
        for (int i = startIndex; i < startIndex + 4; ++i) {
            if ((byteArray[i] & 0xFF) == 48) continue;
            return false;
        }
        return true;
    }

    public byte[] concat(byte[] a, byte[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        byte[] result = new byte[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    private boolean checkTimeout(byte[] data) {
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.checkedTime;
        this.checkedTime = currentTime;
        if ((double)elapsedTime < 30.0) {
            return false;
        }
        return !((double)elapsedTime < 100.0) || data.length >= 20;
    }

    private PacketModel createPacketModel() {
        PacketModel packetModel = new PacketModel();
        if (this.packetArray.size() != 0) {
            packetModel.setPreamble(this.packetArray.get(0));
            packetModel.setType(this.packetArray.get(1));
            packetModel.setCommand(this.packetArray.get(2));
            byte[] length = new byte[]{this.packetArray.get(3), this.packetArray.get(4)};
            packetModel.setLength(length);
            for (int i = 0; i < this.payloadLength; ++i) {
                packetModel.addPayloadData(this.packetArray.get(i + 5));
            }
            int endMarkPosition = 4 + this.payloadLength + 1;
            packetModel.setEndMark(this.packetArray.get(endMarkPosition));
            byte[] crc = new byte[]{this.packetArray.get(endMarkPosition + 1), this.packetArray.get(endMarkPosition + 2)};
            packetModel.setCRC(crc);
        }
        return packetModel;
    }

    private boolean checkPacket(byte[] data) {
        boolean isFirst = false;
        if (this.checkTimeout(data)) {
            if (data.length > 1) {
                isFirst = data[0] == -69 && data[1] == 1 | data[1] == 2;
            } else {
                boolean bl = isFirst = data[0] == -69;
            }
        }
        if (isFirst) {
            this.packetState = CheckPacketState.START;
        }
        block11: for (int i = 0; i < data.length; ++i) {
            switch (this.packetState) {
                case START: {
                    this.payloadLength = 0;
                    this.payloadCount = 0;
                    this.packetArray.clear();
                    if (data[i] != -69) continue block11;
                    this.packetArray.add(data[i]);
                    this.packetState = CheckPacketState.MSG_TYPE;
                    continue block11;
                }
                case MSG_TYPE: {
                    this.packetArray.add(data[i]);
                    this.packetState = CheckPacketState.MSG_CODE;
                    continue block11;
                }
                case MSG_CODE: {
                    this.packetArray.add(data[i]);
                    this.packetState = CheckPacketState.LEN_H;
                    continue block11;
                }
                case LEN_H: {
                    this.packetArray.add(data[i]);
                    this.packetState = CheckPacketState.LEN_L;
                    continue block11;
                }
                case LEN_L: {
                    this.packetArray.add(data[i]);
                    this.payloadLength = this.packetArray.get(4) & 0xFF;
                    this.packetState = this.payloadLength == 0 ? CheckPacketState.PAYLOAD_E : CheckPacketState.PAYLOAD;
                    continue block11;
                }
                case PAYLOAD: {
                    this.packetArray.add(data[i]);
                    ++this.payloadCount;
                    if (this.payloadCount != this.payloadLength) continue block11;
                    this.packetState = CheckPacketState.PAYLOAD_E;
                    continue block11;
                }
                case PAYLOAD_E: {
                    if (126 == data[i]) {
                        this.packetArray.add(data[i]);
                        this.packetState = CheckPacketState.CRC_H;
                        continue block11;
                    }
                    this.packetArray.clear();
                    this.packetState = CheckPacketState.START;
                    continue block11;
                }
                case CRC_H: {
                    this.packetArray.add(data[i]);
                    this.packetState = CheckPacketState.CRC_L;
                    continue block11;
                }
                case CRC_L: {
                    this.packetArray.add(data[i]);
                    int[] checkData = new int[this.packetArray.size()];
                    int baIndex = 0;
                    for (Byte b : this.packetArray.toArray(new Byte[0])) {
                        checkData[baIndex++] = b & 0xFF;
                    }
                    boolean isCheckData = CRCCalculator.Chk_CRC(checkData);
                    if (!isCheckData) {
                        this.packetArray.clear();
                        this.packetState = CheckPacketState.START;
                    } else {
                        CommunicationManager.getInstance().analyzedPacketData(this.createPacketModel());
                    }
                    this.packetState = CheckPacketState.START;
                }
            }
        }
        return false;
    }

    private byte[] getBytesFromByteArray(byte[] byteArray, int startIndex, int length) {
        if (byteArray == null) {
            return null;
        }
        if (byteArray.length < 9) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(byteArray, startIndex, result, 0, length);
        return result;
    }

    private String bytesToAscii(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            if (b >= 0 && b <= 127) {
                sb.append((char)b);
                continue;
            }
            sb.append('?');
        }
        return sb.toString();
    }
}

