/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk.utility;

import android.annotation.SuppressLint;

public class EpcConverter {
    public static final int HEX_STRING = 0;
    public static final int ASCII = 1;
    public static final int SGTIN96 = 2;
    public static final int EAN13 = 3;
    private static final int ID_SGTIN96 = 48;
    private static final int[] gWeighting = new int[]{1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3};
    private static final int[] gCompanyPrefixBitLen = new int[]{40, 37, 34, 30, 27, 24, 20};

    public static String toTypeString(int type) {
        switch (type) {
            case 0: {
                return "HEX";
            }
            case 1: {
                return "ASCII";
            }
            case 2: {
                return "SGTIN96";
            }
            case 3: {
                return "EAN13";
            }
        }
        return null;
    }

    private static String toAscii(int[] data) {
        StringBuilder sb = new StringBuilder(data.length);
        for (int i = EpcConverter.getEpcStartDigit(data); i < data.length; ++i) {
            if (data[i] > 0 && data[i] < 127) {
                sb.append(Character.toString((char)(data[i] & 0xFF)));
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String toHexString(int[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(data[i] & 0xFF).toUpperCase();
            if (hex.length() < 2) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    private static String toBinString(int[] data) {
        if (data.length < 14) {
            return "";
        }
        int startDigit = EpcConverter.getEpcStartDigit(data);
        if (data.length < 12 + startDigit) {
            return "";
        }
        if (data[startDigit] != 48) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = startDigit + 1; i < data.length; ++i) {
            String bin = Integer.toBinaryString(data[i] & 0xFF);
            if (bin.length() < 8) {
                for (int j = 0; j < 8 - bin.length(); ++j) {
                    sb.append('0');
                }
            }
            sb.append(bin);
        }
        return sb.toString();
    }

    private static int getPartition(String bin) {
        return Integer.parseInt(bin.substring(3, 6), 2);
    }

    private static String getCompanyPrefix(String bin) {
        int nPartition = EpcConverter.getPartition(bin);
        int nCompanyPrefixLen = EpcConverter.getCompanyPrefixBitLen(nPartition);
        String binCompanyPrefix = bin.substring(6, 6 + nCompanyPrefixLen);
        long nCompanyPrefix = Long.parseLong(binCompanyPrefix, 2);
        int digitCompanyPrefixLen = 12 - nPartition;
        return EpcConverter.padLeft(Long.toString(nCompanyPrefix), digitCompanyPrefixLen, "0");
    }

    private static int getCompanyPrefixBitLen(int partition) {
        if (partition < 0 || partition > 6) {
            return 0;
        }
        return gCompanyPrefixBitLen[partition];
    }

    private static String getItemReference(String bin) {
        int nPartition = EpcConverter.getPartition(bin);
        int nCompanyPrefixLen = EpcConverter.getCompanyPrefixBitLen(nPartition);
        int nItemReferenceLen = 44 - nCompanyPrefixLen;
        String binItemReference = bin.substring(6 + nCompanyPrefixLen, 6 + nCompanyPrefixLen + nItemReferenceLen);
        long nItemReference = Long.parseLong(binItemReference, 2);
        int digitItemReferenceLen = 1 + nPartition;
        return EpcConverter.padLeft(Long.toString(nItemReference), digitItemReferenceLen, "0");
    }

    private static String getSerial(String bin) {
        int nPartition = EpcConverter.getPartition(bin);
        int nCompanyPrefixLen = EpcConverter.getCompanyPrefixBitLen(nPartition);
        int nItemReferenceLen = 44 - nCompanyPrefixLen;
        String binSerial = bin.substring(6 + nCompanyPrefixLen + nItemReferenceLen, 6 + nCompanyPrefixLen + nItemReferenceLen + 38);
        Long nSerial = Long.parseLong(binSerial, 2);
        return Long.toString(nSerial);
    }

    private static String getFilter(String bin) {
        return Integer.toString(Integer.parseInt(bin.substring(0, 3), 2));
    }

    private static String toSGTIN96(int[] data) {
        String bin = EpcConverter.toBinString(data);
        if (bin.length() == 0) {
            return "NON-SGTIN96";
        }
        return EpcConverter.getFilter(bin) + "." + EpcConverter.getCompanyPrefix(bin) + "." + EpcConverter.getItemReference(bin) + "." + EpcConverter.getSerial(bin);
    }

    private static String toEAN13(int[] data) {
        String bin = EpcConverter.toBinString(data);
        if (bin.length() == 0) {
            return "NON-SGTIN96";
        }
        String message = EpcConverter.getCompanyPrefix(bin) + EpcConverter.getItemReference(bin).substring(1);
        return EpcConverter.appendParity(message);
    }

    public static String toString(int type, int[] data) {
        if (type == 1) {
            return EpcConverter.toAscii(data);
        }
        if (type == 2) {
            return EpcConverter.toSGTIN96(data);
        }
        if (type == 3) {
            return EpcConverter.toEAN13(data);
        }
        return EpcConverter.toHexString(data);
    }

    private static int getEpcStartDigit(int[] data) {
        int digit = 2;
        if ((data[0] & 2) == 2) {
            digit = (data[2] & 8) == 8 ? 6 : 4;
        }
        return digit;
    }

    private static String padLeft(String s, int n, String pad) {
        StringBuilder sb = new StringBuilder();
        if (s.length() < n) {
            for (int i = 0; i < n - s.length(); ++i) {
                sb.append(pad);
            }
        }
        sb.append(s);
        return sb.toString();
    }

    private static String appendParity(String message) {
        int sum = 0;
        int parity = 0;
        for (int i = 0; i < 12; ++i) {
            sum += Integer.parseInt(message.substring(i, i + 1)) * gWeighting[i];
        }
        parity = 10 - sum % 10;
        if (parity == 10) {
            parity = 0;
        }
        return message + Integer.toString(parity);
    }
}

