/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk.manager;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.function.Function;
import jp.co.asterisk.asreader.a3xd.sdk.manager.USBManagerCallback;
import jp.co.asterisk.asreader.a3xd.sdk.utility.LogLevel;
import jp.co.asterisk.asreader.a3xd.sdk.utility.SDKLog;

public class USBManager {
    private static USBManager instance;
    public static final String ACTION_USB_PERMISSION = "com.asreader.sdevice.action.USB_PERMISSION";
    public static final String VID = "10c4";
    public static final String VIDM30S = "339c";
    private final String TAG = USBManager.class.getSimpleName();
    private final int TX_TIMEOUT = 100;
    private Context context;
    private UsbManager usbManager;
    private UsbDevice usbDevice;
    private UsbDeviceConnection usbDeviceConnection;
    private UsbEndpoint endpointIn;
    private UsbEndpoint endpointOut;
    private UsbInterface usbInterface;
    private Thread rxThread;
    private boolean isOpen = false;
    private boolean isRequestPermission = false;
    private USBManagerCallback callback;
    public static int currentUSBType;
    private static final int SET_CONTROL_LINE_STATE = 34;
    private static final int USB_RECIP_INTERFACE = 1;
    private static final int USB_RT_ACM = 33;
    private final Runnable inputProcessor = () -> {
        ByteBuffer buffer = ByteBuffer.allocate(5000);
        UsbRequest request = new UsbRequest();
        request.initialize(this.usbDeviceConnection, this.endpointIn);
        while (this.isOpen) {
            request.queue(buffer);
            UsbRequest response = this.usbDeviceConnection.requestWait();
            if (response == null) break;
            int bufferPos = buffer.position();
            if (bufferPos > 0) {
                byte[] bytes = new byte[buffer.position()];
                buffer.flip();
                buffer.get(bytes);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < bufferPos; ++i) {
                    sb.append(String.format("%02X ", bytes[i]));
                }
                SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "Receive data read: [RX] " + sb.toString());
                this.callback.onReceivedData(bytes);
            }
            buffer.clear();
        }
        request.close();
        this.rxThread = null;
        USBManager uSBManager = this;
        synchronized (uSBManager) {
            this.notifyAll();
        }
        Log.d((String)this.TAG, (String)"RX Thread Finish");
    };

    public void setCallback(USBManagerCallback callback) {
        this.callback = callback;
    }

    public static USBManager getInstance() {
        if (instance == null) {
            instance = new USBManager();
        }
        return instance;
    }

    private USBManager() {
    }

    public boolean isOpen() {
        if (this.usbDevice == null) {
            this.isOpen = false;
        }
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "isOpen : " + this.isOpen);
        return this.isOpen;
    }

    public void initialize(Context context) {
        this.context = context;
        this.usbManager = (UsbManager)context.getSystemService("usb");
    }

    public void open() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "USB Open");
        if (this.usbDevice == null) {
            this.openUsbDevice();
        }
    }

    public boolean isM30SDevice() {
        return currentUSBType == 1;
    }

    private void openUsbDevice() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "openUsbDevice");
        this.usbDevice = this.getDevice();
        if (this.usbDevice == null) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "UsbDevice open fail.");
            return;
        }
        if (!this.usbManager.hasPermission(this.usbDevice)) {
            if (!this.isRequestPermission) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "UsbDevice permission request.");
                this.isRequestPermission = true;
                this.requestPermission();
            }
            this.usbDevice = null;
            return;
        }
        this.isRequestPermission = false;
        if (this.usbDevice.getInterfaceCount() == 0) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "UsbDevice interface count is zero.");
            this.usbDevice = null;
            return;
        }
        this.usbDeviceConnection = this.usbManager.openDevice(this.usbDevice);
        if (String.format("%04x", this.usbDevice.getVendorId()).equalsIgnoreCase(VIDM30S)) {
            currentUSBType = 1;
            try {
                this.setDTR(true);
                this.setRTS(true);
                this.openInterface();
            }
            catch (Exception exception) {}
        } else {
            currentUSBType = 0;
            this.usbInterface = this.usbDevice.getInterface(0);
            SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "getInterface : " + this.usbInterface);
            if (!this.usbDeviceConnection.claimInterface(this.usbInterface, true)) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "USBInterface not found.");
                this.usbDevice = null;
                return;
            }
            int ret = this.cp210xUsbEnable();
            if (ret < 0) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "CP210X Init Fail.");
                this.usbDevice = null;
                return;
            }
            this.setUART(115200, 8, 0, 1, false, false);
            this.endpointIn = this.getEndPoint(128);
            this.endpointOut = this.getEndPoint(0);
        }
        if (this.endpointIn != null && this.endpointOut != null) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "USB Open");
            this.isOpen = true;
            if (this.rxThread == null) {
                this.rxThread = new Thread(this.inputProcessor);
                this.rxThread.start();
            }
        } else {
            this.usbDevice = null;
        }
    }

    private void setDTR(boolean mRts) {
        int value = mRts ? 1 : 0;
        this.sendAcmControlMessage(34, value, null);
    }

    private void setRTS(boolean mRts) {
        int value = mRts ? 2 : 0;
        this.sendAcmControlMessage(34, value, null);
    }

    private int sendAcmControlMessage(int request, int value, byte[] buf) {
        if (this.usbDeviceConnection == null) {
            return -1;
        }
        return this.usbDeviceConnection.controlTransfer(33, request, value, 0, buf, buf != null ? buf.length : 0, 5000);
    }

    private void openInterface() {
        this.usbInterface = this.usbDevice.getInterface(0);
        if (!this.usbDeviceConnection.claimInterface(this.usbInterface, true)) {
            return;
        }
        UsbInterface mDataInterface = null;
        for (int i = 0; i < this.usbDevice.getInterfaceCount(); ++i) {
            if (this.usbDevice.getInterface(i).getInterfaceClass() != 10) continue;
            mDataInterface = this.usbDevice.getInterface(i);
            break;
        }
        if (!this.usbDeviceConnection.claimInterface(mDataInterface, true)) {
            return;
        }
        for (int j = 0; j < mDataInterface.getEndpointCount(); ++j) {
            if (mDataInterface.getEndpoint(j).getType() != 2) continue;
            if (mDataInterface.getEndpoint(j).getDirection() == 0) {
                this.endpointOut = mDataInterface.getEndpoint(j);
            }
            if (mDataInterface.getEndpoint(j).getDirection() != 128) continue;
            this.endpointIn = mDataInterface.getEndpoint(j);
        }
    }

    private void requestPermission() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "Start request permission. ");
        Intent intent = new Intent(ACTION_USB_PERMISSION);
        intent.setPackage(this.context.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context.getApplicationContext(), (int)0, (Intent)intent, (int)0x2000000);
        this.usbManager.requestPermission(this.usbDevice, pendingIntent);
    }

    public void isPermissionRequested(boolean requested) {
        this.isRequestPermission = requested;
    }

    public boolean sendData(byte[] buffer) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "sendData");
        if (!this.isOpen) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "sendData: isOpen is false.");
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buffer.length; ++i) {
            sb.append(String.format("%02X ", buffer[i]));
        }
        if (this.usbDeviceConnection.bulkTransfer(this.endpointOut, buffer, buffer.length, 100) > 0) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "bulkTransfer send :\u3000" + sb.toString());
        } else {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "bulkTransfer failed :  " + sb.toString());
        }
        return true;
    }

    public void close() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "USB Close");
        this.isOpen = false;
        this.isRequestPermission = false;
        if (this.rxThread != null) {
            try {
                this.rxThread.join(50L);
            }
            catch (InterruptedException ex) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "rxThread has not finished.");
                this.rxThread.interrupt();
            }
            this.rxThread = null;
        }
        this.cp210xUSBDisable();
        if (this.usbDeviceConnection != null) {
            this.usbDeviceConnection.releaseInterface(this.usbInterface);
            this.usbDeviceConnection.close();
            this.usbDeviceConnection = null;
        }
        this.usbDevice = null;
        this.usbManager = null;
        this.usbInterface = null;
    }

    private UsbDevice getDevice() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "getDevice");
        if (this.usbDevice == null) {
            if (this.usbManager == null) {
                this.usbManager = (UsbManager)this.context.getSystemService("usb");
            }
            if (this.usbManager.getDeviceList().isEmpty()) {
                return null;
            }
            HashMap deviceList = this.usbManager.getDeviceList();
            for (UsbDevice device : deviceList.values()) {
                if (!String.format("%04x", device.getVendorId()).equalsIgnoreCase(VID) && !String.format("%04x", device.getVendorId()).equalsIgnoreCase(VIDM30S)) continue;
                SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "Permission mDevice count" + device.getInterfaceCount());
                SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "Permission check vid: " + String.format("%04x", device.getVendorId()));
                SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "Permission check pid: " + String.format("%04x", device.getProductId()));
                SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "Permission DeviceID: " + device.getDeviceId());
                SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "Permission DeviceName: " + device.getDeviceName());
                SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "Permission DeviceClass: " + device.getDeviceClass());
                SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "Permission DeviceSubClass: " + device.getDeviceSubclass());
                SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "Permission Permission: " + this.usbManager.hasPermission(device));
                return device;
            }
        }
        return this.usbDevice;
    }

    private int cp210xUsbEnable() {
        if (this.usbDeviceConnection == null) {
            return -1;
        }
        return this.usbDeviceConnection.controlTransfer(65, 0, 1, 0, null, 0, 100);
    }

    private void cp210xUSBDisable() {
        if (this.usbDeviceConnection != null) {
            this.usbDeviceConnection.controlTransfer(65, 0, 0, 0, null, 0, 100);
        }
    }

    private boolean setUART(int baudrate, int dataBits, int parity, int stopBits, boolean dtrOn, boolean rtsOn) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "setUART");
        boolean ret = true;
        boolean res = this.setBaudrate(baudrate);
        ret = ret && res;
        return ret;
    }

    public boolean setBaudrate(int baudrate) {
        Function<Integer, Integer> getBaudrate = val -> {
            if (val <= 300) {
                return 300;
            }
            if (val <= 600) {
                return 600;
            }
            if (val <= 1200) {
                return 1200;
            }
            if (val <= 1800) {
                return 1800;
            }
            if (val <= 2400) {
                return 2400;
            }
            if (val <= 4000) {
                return 4000;
            }
            if (val <= 4803) {
                return 4800;
            }
            if (val <= 7207) {
                return 7200;
            }
            if (val <= 9612) {
                return 9600;
            }
            if (val <= 14428) {
                return 14400;
            }
            if (val <= 16062) {
                return 16000;
            }
            if (val <= 19250) {
                return 19200;
            }
            if (val <= 28912) {
                return 28800;
            }
            if (val <= 38601) {
                return 38400;
            }
            if (val <= 51558) {
                return 51200;
            }
            if (val <= 56280) {
                return 56000;
            }
            if (val <= 58053) {
                return 57600;
            }
            if (val <= 64111) {
                return 64000;
            }
            if (val <= 77608) {
                return 76800;
            }
            if (val <= 117028) {
                return 115200;
            }
            if (val <= 129347) {
                return 128000;
            }
            if (val <= 156868) {
                return 153600;
            }
            if (val <= 237832) {
                return 230400;
            }
            if (val <= 254234) {
                return 250000;
            }
            if (val <= 273066) {
                return 256000;
            }
            if (val <= 491520) {
                return 460800;
            }
            if (val <= 567138) {
                return 500000;
            }
            if (val <= 670254) {
                return 576000;
            }
            if (val < 1000000) {
                return 921600;
            }
            if (val > 2000000) {
                return 2000000;
            }
            return 0;
        };
        byte[] baudBytes = new byte[4];
        this.intToLittleEndianBytes(getBaudrate.apply(baudrate), baudBytes);
        int ret = this.cp210xSetConfig(30, baudBytes, 4);
        if (ret < 0) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "CP210X Fail to setBaudrate");
            return false;
        }
        return true;
    }

    public boolean setDataBits(int dataBits) {
        byte[] buf = new byte[2];
        if (this.cp210xGetConfig(4, buf, buf.length) < 0) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "CP210X Fail to setDataBits cp210xGetConfig");
            return false;
        }
        int bits = this.littleEndianBytesToInt(buf);
        bits &= 0xFFFFF0FF;
        switch (dataBits) {
            case 7: {
                bits |= 0x700;
                break;
            }
            default: {
                bits |= 0x800;
            }
        }
        this.intToLittleEndianBytes(bits, buf);
        int ret = this.cp210xSetConfig(4, buf, buf.length);
        if (ret < 0) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "CP210X Fail to setDataBits");
            return false;
        }
        return true;
    }

    public boolean setParity(int parity) {
        byte[] buf = new byte[2];
        if (this.cp210xGetConfig(4, buf, buf.length) < 0) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "CP210X Fail to setParity cp210xGetConfig");
            return false;
        }
        int bits = this.littleEndianBytesToInt(buf);
        bits &= 0xFFFFFF0F;
        switch (parity) {
            case 1: {
                bits |= 0x10;
                break;
            }
            case 2: {
                bits |= 0x20;
                break;
            }
            case 3: {
                bits |= 0x30;
                break;
            }
            case 4: {
                bits |= 0x40;
                break;
            }
            default: {
                bits |= 0;
            }
        }
        this.intToLittleEndianBytes(bits, buf);
        int ret = this.cp210xSetConfig(4, buf, buf.length);
        if (ret < 0) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "CP210X Fail to setParity");
            return false;
        }
        return true;
    }

    public boolean setStopBits(int stopBits) {
        byte[] buf = new byte[2];
        if (this.cp210xGetConfig(4, buf, buf.length) < 0) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "CP210X Fail to setStopBits cp210xGetConfig");
            return false;
        }
        int bits = this.littleEndianBytesToInt(buf);
        bits &= 0xFFFFFFF0;
        switch (stopBits) {
            case 1: {
                bits |= 1;
                break;
            }
            case 2: {
                bits |= 2;
                break;
            }
            default: {
                bits |= 0;
            }
        }
        this.intToLittleEndianBytes(bits, buf);
        int ret = this.cp210xSetConfig(4, buf, buf.length);
        if (ret < 0) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "CP210X Fail to setStopBits");
            return false;
        }
        return true;
    }

    public boolean setDtrRts(boolean dtrOn, boolean rtsOn) {
        int ctrlValue = 0;
        byte[] buf = new byte[4];
        ctrlValue = dtrOn ? (ctrlValue |= 1) : (ctrlValue &= 0xFFFFFFFE);
        ctrlValue |= 0x100;
        ctrlValue = rtsOn ? (ctrlValue |= 2) : (ctrlValue &= 0xFFFFFFFD);
        this.intToLittleEndianBytes(ctrlValue |= 0x200, buf);
        int ret = this.cp210xSetConfig(7, buf, buf.length);
        if (ret < 0) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "CP210X Fail to setDtrRts");
            return false;
        }
        return true;
    }

    private int cp210xSetConfig(int request, byte[] buf, int size) {
        if (this.usbDeviceConnection == null) {
            return -1;
        }
        int ret = this.usbDeviceConnection.controlTransfer(65, request, 0, 0, buf, size, 100);
        return ret;
    }

    private int cp210xGetConfig(int request, byte[] buf, int size) {
        if (this.usbDeviceConnection == null) {
            return -1;
        }
        return this.usbDeviceConnection.controlTransfer(-63, request, 0, 0, buf, size, 100);
    }

    private void intToLittleEndianBytes(int in, byte[] out) {
        if (out == null || out.length > 4) {
            return;
        }
        for (int i = 0; i < out.length; ++i) {
            out[i] = (byte)(in >> i * 8 & 0xFF);
        }
    }

    private int littleEndianBytesToInt(byte[] in) {
        if (in == null || in.length > 4) {
            return 0;
        }
        int ret = 0;
        for (int i = 0; i < in.length; ++i) {
            ret |= (in[i] & 0xFF) << i * 8;
        }
        return ret;
    }

    private UsbEndpoint getEndPoint(int direction) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "getEndPoint");
        for (int i = 0; i < this.usbInterface.getEndpointCount(); ++i) {
            if (this.usbInterface.getEndpoint(i).getType() != 2 || this.usbInterface.getEndpoint(i).getDirection() != direction) continue;
            return this.usbInterface.getEndpoint(i);
        }
        return null;
    }
}

