/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk.common;

import jp.co.asterisk.asreader.a3xd.sdk.sdevice.AsDeviceException;

public class Convert {
    public static byte[] toBytes(String string) {
        int len = string.length();
        byte[] data = new byte[]{};
        try {
            data = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                data[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            data = new byte[]{};
            e.getMessage();
        }
        return data;
    }

    public static int toInt(byte number) {
        if (number < 0) {
            return 0;
        }
        byte ret = number;
        return ret;
    }

    public static int toInt(byte[] array) throws AsDeviceException {
        return Convert.toInt(array, 0, array.length);
    }

    public static int toInt(byte[] array, int index, int count) throws AsDeviceException {
        if (count <= 0 || index < 0 || index >= array.length || array.length < index + count) {
            throw new AsDeviceException("invalid argument", 2);
        }
        int result = 0;
        for (int i = index; i < index + count; ++i) {
            result += Convert.toInt(array[index + i]);
            if (i == count - 1) continue;
            result <<= 8;
        }
        return result;
    }

    public static String toStringHEX(byte[] array) {
        return Convert.toStringHEX(array, 0, array.length);
    }

    public static String toStringHEX(byte[] array, int start, int count) {
        String result = "";
        for (int i = start; i < start + count; ++i) {
            int num = Convert.toInt(array[i]);
            String string = Integer.toHexString(num);
            result = num <= 15 ? result + "0" + string : result + string;
        }
        return result;
    }

    public static String toStringHEX(int[] array) {
        return Convert.toStringHEX(array, 0, array.length);
    }

    public static String toStringHEX(int[] array, int start, int count) {
        String result = "";
        for (int i = start; i < start + count; ++i) {
            int num = array[i];
            String string = Integer.toHexString(num);
            result = num <= 15 ? result + "0" + string : result + string;
        }
        return result;
    }

    public static String toStringDecimal(byte[] array) {
        return Convert.toStringDecimal(array, 0, array.length);
    }

    public static String toStringDecimal(byte[] array, int start, int count) {
        String result = "";
        for (int i = start; i < start + count; ++i) {
            int num = Convert.toInt(array[i]);
            String string = Integer.toString(num);
            result = result + string;
        }
        return result;
    }

    public static long toLong(byte[] array, int index, int count) throws AsDeviceException {
        if (count <= 0 || index < 0 || index >= array.length || array.length < index + count) {
            throw new AsDeviceException("invalid argument", 2);
        }
        long result = 0L;
        for (int i = index; i < index + count; ++i) {
            result += (long)Convert.toInt(array[index + i]);
            if (i == count - 1) continue;
            result <<= 8;
        }
        return result;
    }
}

