/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk;

import android.content.Context;
import android.content.SharedPreferences;

public class SharedPreferencesHelper {
    private static SharedPreferencesHelper instance;
    private final String NAME = "ASR-A3XD-SDK-PREF";
    private final String PREF_KEY_MAX_TAG = "PREF_KEY_MAX_TAG";
    private final String PREF_KEY_MAX_TIME = "PREF_KEY_MAX_TIME";
    private final String PREF_KEY_REPEAT_CYCLE = "PREF_KEY_REPEAT_CYCLE";
    private final String PREF_KEY_RSSI = "PREF_KEY_RSSI";
    private final String PREF_KEY_CONTINUE_MODE = "PREF_KEY_CONTINUE_MODE";
    private SharedPreferences sharedPreferences;

    private SharedPreferencesHelper() {
    }

    public static SharedPreferencesHelper getInstance() {
        if (instance == null) {
            instance = new SharedPreferencesHelper();
        }
        return instance;
    }

    public void initialize(Context context) {
        this.sharedPreferences = context.getSharedPreferences("ASR-A3XD-SDK-PREF", 0);
    }

    public int getMaxTag() {
        return this.sharedPreferences.getInt("PREF_KEY_MAX_TAG", 0);
    }

    public void setMaxTag(int maxTag) {
        this.sharedPreferences.edit().putInt("PREF_KEY_MAX_TAG", maxTag).apply();
    }

    public int getMaxTime() {
        return this.sharedPreferences.getInt("PREF_KEY_MAX_TIME", 0);
    }

    public void setMaxTime(int maxTime) {
        this.sharedPreferences.edit().putInt("PREF_KEY_MAX_TIME", maxTime).apply();
    }

    public int getRepeatCycle() {
        return this.sharedPreferences.getInt("PREF_KEY_REPEAT_CYCLE", 0);
    }

    public void setRepeatCycle(int repeatCycle) {
        this.sharedPreferences.edit().putInt("PREF_KEY_REPEAT_CYCLE", repeatCycle).apply();
    }

    public boolean getRssi() {
        return this.sharedPreferences.getBoolean("PREF_KEY_RSSI", true);
    }

    public void setRssi(boolean enable) {
        this.sharedPreferences.edit().putBoolean("PREF_KEY_RSSI", enable).apply();
    }

    public boolean getContinueMode() {
        return this.sharedPreferences.getBoolean("PREF_KEY_CONTINUE_MODE", true);
    }

    public void setContinueMode(boolean enable) {
        this.sharedPreferences.edit().putBoolean("PREF_KEY_CONTINUE_MODE", enable).apply();
    }
}

