﻿using AsReaderSDK4.IOS;
using AsReaderSDK4MAUIDemo.Platforms.iOS;
using Foundation;
using UIKit;

namespace AsReaderSDK4MAUIDemo;

public partial class InformationPage : ContentPage
{
    private AsReaderDockManager asReaderDockManager;
    private AsReaderDockManagerDelegate asReaderDockManagerDelegate;
    private const int REGION_KOREA_OLD = 0x01;
    private const int REGION_USA_OLD = 0x02;
    private const int REGION_EUROPE_OLD = 0x04;
    private const int REGION_JAPAN_OLD = 0x08;
    private const int REGION_CHINA2_OLD = 0x10;
    private const int REGION_CHINA1_OLD = 0x16;
    private const int REGION_KOREA = 0x11;
    private const int REGION_USA = 0x21;
    private const int REGION_USA2 = 0x22;
    private const int REGION_EUROPE = 0x31;
    private const int REGION_JAPAN = 0x41;
    private const int REGION_CHINA1 = 0x51;
    private const int REGION_CHINA2 = 0x52;
    private const int REGION_AU_HK = 0x71;
    private const int REGION_BRAZIL1 = 0x61;
    private const int REGION_BRAZIL2 = 0x62;
    private const int REGION_AUSTRALIA = 0x0E;

    public InformationPage()
	{
		InitializeComponent();
        Title = "Information";
        asReaderDockManager = AsReaderDockManager.sharedInstance();
        asReaderDockManagerDelegate = AsReaderDockManagerDelegate.sharedInstance();
    }
    protected override void OnAppearing()
    {
        base.OnAppearing();
        asReaderDockManagerDelegate.Plugged = (plug) =>
        {
            Plugged(plug);
        };
        asReaderDockManagerDelegate.BatteryReceived = (battery) =>
        {
            BatteryReceived(battery);
        };
        asReaderDockManagerDelegate.RegionReceived = (region) =>
        {
            RegionReceived(region);
        };
        asReaderDockManagerDelegate.RfidModuleVersionReceived = () =>
        {
            RfidModuleVersionReceived();
        };
        dllVersionLabel.Text = asReaderDockManager.getAsReaderDockSDK4DLLVersion();
        sdkVersionLabel.Text = asReaderDockManager.getAsReaderDockSDK4SDKVersion();
        appInfoLabel.Text = "major:" + GetAPPVersion() + " (" + GetAPPBuild() + ")";
        modelLabel.Text = asReaderDockManager.getAsReaderDockSDK4Model();
        hwvLabel.Text = asReaderDockManager.getAsReaderDockSDK4HWVVersion();
        fwvLabel.Text = asReaderDockManager.getAsReaderDockSDK4FWVVersion();
        if (asReaderDockManager.getAsReaderDockSDK4Region())
        {
            Device.StartTimer(TimeSpan.FromSeconds(0.5), onTick);
        }
        if (asReaderDockManager.getIs025S() || asReaderDockManager.getIsM30S())
        {
            int battery = asReaderDockManager.getBattery();
            BatteryReceived(battery);
        }
    }
    protected override void OnDisappearing()
    {
        base.OnDisappearing();
        asReaderDockManagerDelegate.Plugged = null;
        asReaderDockManagerDelegate.BatteryReceived = null;
        asReaderDockManagerDelegate.RegionReceived = null;
        asReaderDockManagerDelegate.RfidModuleVersionReceived = null;
    }
    private bool onTick()
    {
        asReaderDockManager.getAsReaderDockSDK4RFIDModule();
        return false;
    }
    private string GetAPPVersion()
    {
        return NSBundle.MainBundle.InfoDictionary["CFBundleShortVersionString"].ToString();
    }
    private string GetAPPBuild()
    {
        return NSBundle.MainBundle.InfoDictionary["CFBundleVersion"].ToString();
    }
    private void Plugged(bool plug)
    {
        MainThread.BeginInvokeOnMainThread(() =>
        {
            if (!plug)
            {
                Navigation.PopToRootAsync();
            }
        });
    }
    private void BatteryReceived(int battery)
    {
        MainThread.BeginInvokeOnMainThread(() =>
        {
            batteryLabel.Text = battery.ToString() + " %";
        });
    }
    private void RegionReceived(int region)
    {
        MainThread.BeginInvokeOnMainThread(() =>
        {
            String strBand = "";
            switch (region)
            {
                case REGION_KOREA_OLD:
                case REGION_KOREA:
                    strBand = "KOREA";
                    break;
                case REGION_USA_OLD:
                    if (asReaderDockManager.getIsM30S())
                    {
                        strBand = "US";
                    }
                    else
                    {
                        strBand = "US(OLD Type)";
                    }
                    break;
                case REGION_USA:
                    strBand = "US1(North)";
                    break;
                case REGION_USA2:
                    strBand = "US2";
                    break;
                case REGION_EUROPE_OLD:
                case REGION_EUROPE:
                    strBand = "EU";
                    break;
                case REGION_JAPAN_OLD:
                case REGION_JAPAN:
                    strBand = "JAPAN";
                    break;
                case REGION_CHINA2_OLD:
                case REGION_CHINA1_OLD:
                case REGION_CHINA1:
                case REGION_CHINA2:
                    strBand = "CHINA";
                    break;
                case REGION_AU_HK:
                    strBand = "ASIA";
                    break;
                case REGION_BRAZIL1:
                case REGION_BRAZIL2:
                    strBand = @"Brazil";
                    break;
                case REGION_AUSTRALIA:
                    strBand = @"Australia";
                    break;
                default:
                    strBand = "Unkown";
                    break;
            }
            regionLabel.Text = strBand;
        });
    }
    private void RfidModuleVersionReceived()
    {
        MainThread.BeginInvokeOnMainThread(() =>
        {
            rfModuleLabel.Text = asReaderDockManager.getAsReaderDockSDK4RFIDModuleVersion();
        });
    }
}
