//
//  ExcelData.m
//  AsReaderLR
//
//  Created by mac on 2018/11/27.
//  Copyright © 2018年 asterisk. All rights reserved.
//

#import "ExcelData.h"
#import <xlsxwriter/xlsxwriter.h>
@interface AsBarcodeItem : NSObject

@property (readwrite, nonatomic) int barcodeType;
@property (strong, nonatomic) NSString *codeId;
@property (strong, nonatomic) NSString *barcode;
@property (strong, nonatomic) NSString *dateTime;
@property (strong, nonatomic) NSString *count;
@end
@interface AsTagItem : NSObject

@property (strong, nonatomic) NSString *tag;
@property (strong, nonatomic) NSString *tid;
@property (nonatomic) int count;
@property (nonatomic) float rssi;
@property (nonatomic) float phase;
@property (nonatomic) float frequency;
@property (strong, nonatomic) NSString *dateTime;

@end


@implementation ExcelData
+ (NSString *)filePath:(NSString *)fileName export:(ExportType)type{
    
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *path = [paths objectAtIndex:0];
    NSString *filePath = @"";
    switch (type) {
            case barcodeExportType:
        {
            filePath = [path stringByAppendingPathComponent:@"Barcode"];
        }
            break;
            case rfidExportType:
        {
            filePath = [path stringByAppendingPathComponent:@"RFID"];
        }
            break;
        default:
            break;
    }
    
    NSFileManager *fileManager = [NSFileManager defaultManager];
    if (![fileManager fileExistsAtPath:filePath]) {
        [fileManager createDirectoryAtPath:filePath withIntermediateDirectories:YES attributes:nil error:nil];
    }
    filePath = [filePath stringByAppendingPathComponent:fileName];
    return filePath;
}

+ (void) createExcelWithFileName:(NSString *)fileName export:(ExportType)type{
    
    NSFileManager *fileManager = [NSFileManager defaultManager];
    if (![fileManager createFileAtPath:[self filePath:fileName export:type]  contents:nil attributes:nil]) {
    }
};

+ (void) exportRfidExcel:(NSString *)fileName withArray:(NSMutableArray *)array export:(ExportType)type isEpc:(BOOL)isEpc isRssi:(BOOL)isRssiOn isTid:(BOOL)isTidOn{
    if (array.count == 0) {
        [self showAlertWithTitle:nil message:@"RFID File Export Error"];
        return;
    }
    const char *filePathChar = [[self filePath:fileName export:type] UTF8String];

    // 创建新xlsx文件，路径需要转成c字符串
    lxw_workbook  *workbook  = workbook_new(filePathChar);
    // 创建sheet
    lxw_worksheet *worksheet = workbook_add_worksheet(workbook, NULL);
    // 添加格式
    lxw_format *format = workbook_add_format(workbook);
    
    //设置格式
    format_set_font_color(format, LXW_COLOR_BLACK);
    format_set_align(format, LXW_ALIGN_CENTER);// 水平居中
    format_set_align(format, LXW_ALIGN_VERTICAL_CENTER);//垂直居中

    lxw_format *liftformat = workbook_add_format(workbook);
    format_set_font_color(liftformat, LXW_COLOR_BLACK);
    format_set_align(liftformat, LXW_ALIGN_LEFT);// 水平居中
 
    lxw_format *rightFormat = workbook_add_format(workbook);
    format_set_font_color(rightFormat, LXW_COLOR_BLACK);
    format_set_align(rightFormat, LXW_ALIGN_RIGHT);// 水平居中
    
    // 设置列宽
    worksheet_set_column(worksheet, COLS("A:A"), 70, NULL);
    worksheet_set_column(worksheet, COLS("B:B"), 23, NULL);
    worksheet_set_column(worksheet, COLS("C:C"), 10, NULL);
    if(isRssiOn&isTidOn)
    {
      worksheet_set_column(worksheet, COLS("D:D"), 10, NULL);
      worksheet_set_column(worksheet, COLS("E:E"), 70, NULL);
    }
    else if(isRssiOn)
      worksheet_set_column(worksheet, COLS("D:D"), 10, NULL);
    else if(isTidOn)
      worksheet_set_column(worksheet, COLS("D:D"), 70, NULL);
    
    //第一行
    int cellIndex = 0;
    if (isEpc) {
        worksheet_write_string(worksheet, 0, cellIndex++, "pcepc hex", format);
    }else{
        worksheet_write_string(worksheet, 0, cellIndex++, "epc hex", format);
    }
    worksheet_write_string(worksheet, 0, cellIndex++, "time", format);
    
    worksheet_write_string(worksheet, 0, cellIndex++, "count", format);
    if(isRssiOn)
        worksheet_write_string(worksheet, 0, cellIndex++, "rssi", format);
    if(isTidOn)
        worksheet_write_string(worksheet, 0, cellIndex++, "tid", format);
    
    int i = 1;
    for (NSDictionary *dic in array) {
        char tagChar[1000];
        char rssiChar[100];
        char tidChar[500];
        char dateTimeChar[1000];
        NSString *tagString = [dic objectForKey:@"tag"];
        NSString *timeString = [dic objectForKey:@"dateTime"];
        NSString *countString = [dic objectForKey:@"count"];
        NSString *rssiString = [dic objectForKey:@"rssi"];
        NSString *tidString = [dic objectForKey:@"tid"];
        int count = countString.intValue;
        NSString *tagStr = @"";
        if (isEpc) {
            tagStr = tagString;
        }else{
            tagStr = [tagString substringFromIndex:4];
        }
        
        strcpy(tagChar,(char *)[tagStr UTF8String]);
        strcpy(dateTimeChar,(char *)[timeString UTF8String]);
        strcpy(rssiChar,(char *)[rssiString UTF8String]);
        strcpy(tidChar,(char *)[tidString UTF8String]);
        cellIndex = 0;
        worksheet_write_string(worksheet, i, cellIndex++, tagChar, liftformat);
        worksheet_write_string(worksheet, i, cellIndex++, dateTimeChar, rightFormat);
        worksheet_write_number(worksheet, i, cellIndex++, count, rightFormat);
        if(isRssiOn)
            worksheet_write_string(worksheet, i, cellIndex++, rssiChar, rightFormat);
        
        if(isTidOn)
            worksheet_write_string(worksheet, i, cellIndex++, tidChar, liftformat);
        i ++;
    }
    workbook_close(workbook);
    
    [self showAlertWithTitle:nil message:@"RFID File Export Success"];
}


+ (void) exportBarcodeExcel:(NSString *)fileName withArray:(NSMutableArray *)array export:(ExportType)type {
    if (array.count == 0) {
        [self showAlertWithTitle:nil message:@"Barcode File Export Error"];
        return;
    }
    
    // 创建新xlsx文件，路径需要转成c字符串
    lxw_workbook  *workbook  = workbook_new([[self filePath:fileName export:type] UTF8String]);
    // 创建sheet
    lxw_worksheet *worksheet = workbook_add_worksheet(workbook, NULL);
    // 添加格式
    lxw_format *format = workbook_add_format(workbook);
    
    //设置格式
    format_set_font_color(format, LXW_COLOR_BLACK);
    format_set_align(format, LXW_ALIGN_CENTER);// 水平居中
    format_set_align(format, LXW_ALIGN_VERTICAL_CENTER);//垂直居中
    
    
    lxw_format *liftformat = workbook_add_format(workbook);
    format_set_font_color(liftformat, LXW_COLOR_BLACK);
    format_set_align(liftformat, LXW_ALIGN_LEFT);// 水平居中
    
    lxw_format *rightFormat = workbook_add_format(workbook);
    format_set_font_color(rightFormat, LXW_COLOR_BLACK);
    format_set_align(rightFormat, LXW_ALIGN_RIGHT);// 水平居中
    
    // 设置列宽
    worksheet_set_column(worksheet, COLS("A:A"), 50, NULL);
    worksheet_set_column(worksheet, COLS("B:B"), 25, NULL);
    worksheet_set_column(worksheet, COLS("C:C"), 10, NULL);

    //第一行
    worksheet_write_string(worksheet, 0, 0, "barcode", format);
    worksheet_write_string(worksheet, 0, 1, "time", format);
    
    int i = 1;
    for (NSDictionary *dic in array) {
        char tagChar[65535];
        char dateTimeChar[1000];
        NSString *tagString = [dic objectForKey:@"barcode"];
        NSString *timeString = [dic objectForKey:@"time"];
        strcpy(tagChar,(char *)[tagString UTF8String]);
        strcpy(dateTimeChar,(char *)[timeString UTF8String]);
        worksheet_write_string(worksheet, i, 0, tagChar, liftformat);
        worksheet_write_string(worksheet, i, 1, dateTimeChar, rightFormat);
        i ++;
    }
    workbook_close(workbook);
    
    [self showAlertWithTitle:nil message:@"Barcode File Export Success"];
}

+ (void)redirectNSLogToDocumentFolder{
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask, YES);
    NSString *documentsDirectory = [paths objectAtIndex:0];
    NSString *fileName =[NSString stringWithFormat:@"%@.txt",@"writelog"];
    NSString *logFilePath = [documentsDirectory stringByAppendingPathComponent:fileName];
    freopen([logFilePath cStringUsingEncoding:NSASCIIStringEncoding],"a+",stderr);
}

+ (void)removeLogFile{
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask, YES);
    NSString *documentsDirectory = [paths objectAtIndex:0];
    NSString *fileName =[NSString stringWithFormat:@"%@.txt",@"writelog"];
    NSString *logFilePath = [documentsDirectory stringByAppendingPathComponent:fileName];
    float logSize = 0;
    NSFileManager* manager = [NSFileManager defaultManager];
    if ([manager fileExistsAtPath:logFilePath]){
        logSize = [[manager attributesOfItemAtPath:logFilePath error:nil] fileSize]/(1024.0*1024);
    }
    if (logSize >= 1 ) {
        if ([[NSFileManager defaultManager] fileExistsAtPath:logFilePath]) {
            [[NSFileManager defaultManager] removeItemAtPath:logFilePath error:nil];
        }
    }
}

+ (void)showAlertWithTitle:(NSString *)title message:(NSString *)message{
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:title message:message preferredStyle:UIAlertControllerStyleAlert];
    [alert addAction:[UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
    }]];
    UIViewController *viewController = [UIApplication sharedApplication].keyWindow.rootViewController;
    UIViewController *viVC = [self findBestViewController:viewController];
    [viVC presentViewController:alert animated:NO completion:nil];
}

+ (UIViewController*)findBestViewController:(UIViewController*)vc {
    if (vc.presentedViewController) {
        return [self findBestViewController:vc.presentedViewController];
    } else if ([vc isKindOfClass:[UISplitViewController class]]) {
        
        UISplitViewController* svc = (UISplitViewController*) vc;
        if (svc.viewControllers.count > 0)
            return [self findBestViewController:svc.viewControllers.lastObject];
        else
            return vc;
    } else if ([vc isKindOfClass:[UINavigationController class]]) {
        
        UINavigationController* svc = (UINavigationController*) vc;
        if (svc.viewControllers.count > 0)
            return [self findBestViewController:svc.topViewController];
        else
            return vc;
    } else if ([vc isKindOfClass:[UITabBarController class]]) {
        UITabBarController* svc = (UITabBarController*) vc;
        if (svc.viewControllers.count > 0)
            return [self findBestViewController:svc.selectedViewController];
        else
            return vc;
    } else {
        return vc;
    }
}
@end
