//
//  CSVData.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/12.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

let currentVC = AsReaderGUNManager.sharedAsReaderGUNManager.getCurrentVC()
final class CSVData: NSObject {
    final class func filePath(_ fileName: String?) -> String? {
        let paths = NSSearchPathForDirectoriesInDomains(.documentDirectory, .userDomainMask, true)
        let path = paths[0]
        guard let newFileName = fileName else {
            return ""
        }
        let filePath = URL(fileURLWithPath: path).appendingPathComponent(newFileName).absoluteString
        return filePath
    }
    final class func isFileExist(_ fileName: String?) -> Bool {
        let fileManager = FileManager.default
        guard let newFileName = filePath(fileName) else {
            return false
        }
        let result: Bool = fileManager.fileExists(atPath: newFileName)
        return result
    }
    final class func deleteFile(forFileName fileName: String?) {
        let fileManager = FileManager.default
        guard let newFileName = filePath(fileName) else {
            return
        }
        try? fileManager.removeItem(atPath: newFileName)
    }
    final class func createCSV(withFileName fileName: String?) {
        let fileManager = FileManager.default
        guard let newFileName = filePath(fileName) else {
            return
        }
        fileManager.createFile(atPath: newFileName, contents: nil, attributes: nil)
    }
    final class func exportRfidCSV(_ fileName: String?, withArray array: [AsTagItem], isEpc: Bool, isRSSI: Bool, isTid: Bool) {
        guard let newFileName = filePath(fileName) else {
            return
        }
        guard  let fileURL: URL = URL.init(string: newFileName) else {
            return
        }
        guard let output = OutputStream(url: fileURL, append: false) else {
            return
        }
        output.open()
        let hasSpaceAvailable = output.hasSpaceAvailable
        if hasSpaceAvailable {
            if !hasSpaceAvailable {
                let alertController = UIAlertController(title: "",
                                                        message: "Output Error",
                                                        preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                alertController.addAction(okAction)
                currentVC?.present(alertController, animated: true, completion: nil)
                return
            } else {
                var header: String


                var strRssi = ""
                if isRSSI == true {
                    strRssi = ",rssi"
                }

                var strTid = "";
                if isTid == true {
                    strTid = ",tid"
                }

                if isEpc {
                    header = String.init(format: "pcepc hex,count,time%@%@\n", strRssi, strTid)
                } else {
                    header = String.init(format: "epc hex,count,time%@%@\n", strRssi, strTid)
                }
                guard let data = header.data(using: String.Encoding.utf8, allowLossyConversion: false) else {
                    return
                }
                let dataMutablePointer = UnsafeMutablePointer<UInt8>.allocate(capacity: data.count)
                data.copyBytes(to: dataMutablePointer, count: data.count)
                let dataPointer = UnsafePointer<UInt8>(dataMutablePointer)
                let headerLength: Int = data.count
                var result: Int = output.write(dataPointer, maxLength: headerLength)

                if result <= 0 {
                    let alertController = UIAlertController(title: "",
                                                            message: "Output Error",
                                                            preferredStyle: .alert)
                    let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                    alertController.addAction(okAction)
                    currentVC?.present(alertController, animated: true, completion: nil)
                    return
                }
                for item in array {
                    var row = ""
                    if isEpc {
                        row = "\(item.tag),\(item.count),\(item.dateTime),\(item.rssi),\(item.tid)\n"

                    } else {
                        let index = item.tag.index(item.tag.endIndex, offsetBy: Int(4 - item.tag.count))
                        let tagStr: String = String(item.tag[index...])
                        row = "\(tagStr),\(item.count),\(item.dateTime),\(item.rssi),\(item.tid)\n"
                    }
                    guard let rowData = row.data(using: String.Encoding.utf8, allowLossyConversion: false) else {
                        return
                    }
                    let rowMutablePointer = UnsafeMutablePointer<UInt8>.allocate(capacity: rowData.count)
                    rowData.copyBytes(to: rowMutablePointer, count: rowData.count)
                    let rowPointer = UnsafePointer<UInt8>(rowMutablePointer)
                    let rowDataLength: Int = rowData.count
                    result = output.write(rowPointer, maxLength: rowDataLength)
                    if result <= 0 {
                        let alertController = UIAlertController(title: "RFID File Export Success",
                                                                message: "",
                                                                preferredStyle: .alert)
                        let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                        alertController.addAction(okAction)
                        currentVC?.present(alertController, animated: true, completion: nil)
                        return
                    }
                }
                let alertController = UIAlertController(title: "RFID File Export Success",
                                                        message: "",
                                                        preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                alertController.addAction(okAction)
                currentVC?.present(alertController, animated: true, completion: nil)
                output.close()
            }
        }
    }
    final class func exportBarcodeCSV(_ fileName: String?, withArray array: [AsBarcodeItem]?) {
        guard let filePathName: String = filePath(fileName) else {
            return
        }
        guard let fileURL: URL = URL.init(string: filePathName) else {
            return
        }
        guard let output = OutputStream(url: fileURL, append: false) else {
            return
        }
        output.open()
        let hasSpaceAvailable =  output.hasSpaceAvailable
        if hasSpaceAvailable {
            if !hasSpaceAvailable {
                let alertController = UIAlertController(title: "",
                                                        message: "Output Error",
                                                        preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                alertController.addAction(okAction)
                currentVC?.present(alertController, animated: true, completion: nil)
                return
            } else {
                var header = ""
                header = "barcode,time\n"
                guard let data = header.data(using: String.Encoding.utf8, allowLossyConversion: false) else {
                    return
                }
                let dataMutablePointer = UnsafeMutablePointer<UInt8>.allocate(capacity: data.count)
                data.copyBytes(to: dataMutablePointer, count: data.count)
                let dataPointer = UnsafePointer<UInt8>(dataMutablePointer)
                let dataDataLength: Int = data.count
                var  result = output.write(dataPointer, maxLength: dataDataLength)
                if result <= 0 {
                    let alertController = UIAlertController(title: "",
                                                            message: "Output Error",
                                                            preferredStyle: .alert)
                    let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                    alertController.addAction(okAction)
                    currentVC?.present(alertController, animated: true, completion: nil)
                    return
                }
                if let aArray = array {
                    for item in aArray {
                        let row: String = "\(item.barcode),\(item.dateTime)\n"
                        guard let rowData = row.data(using: String.Encoding.utf8, allowLossyConversion: false) else {
                            return
                        }
                        let rowMutablePointer = UnsafeMutablePointer<UInt8>.allocate(capacity: (rowData.count))
                        rowData.copyBytes(to: rowMutablePointer, count: rowData.count)
                        let rowPointer = UnsafePointer<UInt8>(rowMutablePointer)
                        let rowDataLength: Int = rowData.count
                        result = output.write(rowPointer, maxLength: rowDataLength)
                        if result <= 0 {
                            let alertController = UIAlertController(title: "Barcode File Export Error",
                                                                    message: "",
                                                                    preferredStyle: .alert)
                            let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                            alertController.addAction(okAction)
                            currentVC?.present(alertController, animated: true, completion: nil)
                            return
                        }
                    }
                }
                let alertController = UIAlertController(title: "Barcode File Export Success",
                                                        message: "",
                                                        preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                alertController.addAction(okAction)
                currentVC?.present(alertController, animated: true, completion: nil)
                output.close()
            }
        }
    }
}
