//
//  AsTagItem.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/3.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit
import AsReaderGunSDK

final class AsTagItem: NSObject {
    public  var tag = ""
    public  var tid = ""
    public  var count: Int = 0
    public  var rssi: Float = 0.0
    public  var phase: Float = 0.0
    public  var frequency: Float = 0.0
    public  var dateTime = ""
    override init() {
        super.init()
    }
    static func item(with tag: String?, rssi: Float, phase: Float, frequency: Float, tid: String?) -> Any {
        let item: AsTagItem = AsTagItem()
        item.tag = tag ?? ""
        item.tid = tid ?? ""
        item.rssi = rssi
        item.phase = phase
        item.frequency = frequency
        item.count = 1
        let timeDate = Date()
        let formatter = DateFormatter()
        formatter.dateStyle = .medium
        formatter.timeStyle = .short
        formatter.dateFormat = "YYYY/MM/dd HH:mm:ss"
        let dateTime = formatter.string(from: timeDate)
        item.dateTime = dateTime
        return item
    }
    func updateRssi(_ rssi: Float, withPhase phase: Float, frequency: Float) {
        let timeDate = Date()
        let formatter = DateFormatter()
        formatter.dateStyle = .medium
        formatter.timeStyle = .short
        formatter.dateFormat = "YYYY/MM/dd HH:mm:ss"
        let dateTime = formatter.string(from: timeDate)
        self.dateTime = dateTime
        self.rssi = rssi
        self.phase = phase
        self.frequency = frequency
    }
    func updateRssi(_ rssi: Float, withPhase phase: Float, frequency: Float, data: String) {
        let timeDate = Date()
        let formatter = DateFormatter()
        formatter.dateStyle = .medium
        formatter.timeStyle = .short
        formatter.dateFormat = "YYYY/MM/dd HH:mm:ss"
        let dateTime = formatter.string(from: timeDate)
        self.dateTime = dateTime
        self.rssi = rssi
        self.phase = phase
        self.frequency = frequency
        self.tid = data
    }
}
