
//
//  ExportTableViewController.swift
//  AsReaderGUN
//
//  Created by mac on 2020/6/11.
//  Copyright © 2020 Asterisk. All rights reserved.
//

import UIKit
let cell_identifier = "tableViewCell"

class ExportTableViewController: UITableViewController {
    var exportType: String? = ""
    private var dataArray: [String] = []
    private var fileManager: FileManager = FileManager.default
    private var filePath: String = ""
    private var asReaderGUNManager: AsReaderGUNManager! = AsReaderGUNManager.sharedAsReaderGUNManager
    private var databaseManeger: DatabaseManeger?
    override func viewDidLoad() {
        super.viewDidLoad()
        tableView.register(UITableViewCell.classForCoder(), forCellReuseIdentifier: cell_identifier)
        let paths = NSSearchPathForDirectoriesInDomains(.documentDirectory, .userDomainMask, true)
        let path = paths[0]
        if (exportType == "csvInven") {
            filePath = path.appending("/" + "RFID")
            self.navigationItem.title = "CSV List"
        } else if (exportType == "csvBarcode") {
            filePath = path.appending("/" + "Barcode")
            self.navigationItem.title = "CSV List";
        } else if (exportType == "excelInven") {
            filePath = path.appending("/" + "RFID")
            self.navigationItem.title = "Excel List";
        } else if (exportType == "excelBarcode") {
            filePath = path.appending("/" + "Barcode")
            self.navigationItem.title = "Excel List";
        }
        datasource()
    }
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        asReaderGUNManager.asReaderGUNManagerDelegate = self
    }
    // MARK: - Table view data source
    override func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }

    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return dataArray.count
    }

    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: cell_identifier, for: indexPath)
        let fileName: String = dataArray[indexPath.row]
        cell.textLabel?.text = fileName
        return cell
    }

    override func tableView(_ tableView: UITableView, editActionsForRowAt indexPath: IndexPath) -> [UITableViewRowAction]? {
        let deleteAction: UITableViewRowAction = UITableViewRowAction (style: UITableViewRowAction.Style.normal, title: "Delete") { (UITableViewRowAction, IndexPath) in
            tableView.setEditing(false, animated: true)
            var fileName: String = self.dataArray[indexPath.row]
            fileName = self.filePath.appending("/" + fileName)
            if self.fileManager.fileExists(atPath: fileName) {
                do {
                    try self.fileManager.removeItem(atPath: fileName)
                    self.datasource()
                } catch { }
            }
        }
        deleteAction.backgroundColor = UIColor.red
        return [deleteAction]
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        var fileName: String = dataArray[indexPath.row]
        fileName = filePath.appending("/" + fileName)
        if fileManager.fileExists(atPath: fileName) {
            let url: URL = URL.init(fileURLWithPath: fileName)
            let documentController: UIDocumentInteractionController = UIDocumentInteractionController.init(url: url)
            documentController.delegate = self
            documentController.presentPreview(animated: true)
        }
    }
}

extension ExportTableViewController: UIDocumentInteractionControllerDelegate {
    func documentInteractionControllerViewControllerForPreview(_ controller: UIDocumentInteractionController) -> UIViewController {
        return self
    }
}

// MARK: - Custom
extension ExportTableViewController {
    private func nowViewWillDisappear() {
        if let operationCount = databaseManeger?.insertOperation.operationCount {
            if operationCount > 0 {
                AsReaderGUNManager.dismissGlobalHUD()
                AsReaderGUNManager.showGlobalProgressHUD(withTitle: "Data Insert...")
                CATransaction.commit()
                print("wait")
                while true {
                    Thread.sleep(forTimeInterval: 0.5)
                    if databaseManeger?.insertOperation.operationCount == 0 {
                        print("wait")
                        break
                    }
                }
                AsReaderGUNManager.dismissGlobalHUD()
                CATransaction.commit()
            } else {
                return
            }
        } else {
            return
        }
    }

    private func datasource() {
        AsReaderGUNManager.showGlobalProgressHUD(withTitle: "Loading")
        dataArray.removeAll()
        var array: [String] = []
        var arr: [String] = []
        var fileNameArray: [String] = []

        guard let enumerator: FileManager.DirectoryEnumerator = fileManager.enumerator(atPath: filePath) else {
            AsReaderGUNManager.dismissGlobalHUD()
            CATransaction.commit()
            return
        }
        while let element = enumerator.nextObject() as? String {
            if (enumerator.fileAttributes?[FileAttributeKey.type] as! FileAttributeType == FileAttributeType.typeRegular){
                array.append(element)
            }
        }
        if !array.isEmpty {
            for string in array {
                if (exportType == "csvInven") {
                    if "csv" == URL(fileURLWithPath: string).pathExtension {
                        arr.append(string)
                    }
                } else if (exportType == "csvBarcode") {
                    if "csv" == URL(fileURLWithPath: string).pathExtension {
                        arr.append(string)
                    }
                } else if (exportType == "excelInven") {
                    if "xlsx" == URL(fileURLWithPath: string).pathExtension {
                        arr.append(string)
                    }
                } else if (exportType == "excelBarcode") {
                    if "xlsx" == URL(fileURLWithPath: string).pathExtension {
                        arr.append(string)
                    }
                }
            }
        }
        if !arr.isEmpty {
            for str in arr {
                var string: String = ""
                if (exportType == "csvInven") {
                    let index1 = str.index(str.startIndex, offsetBy: 5)
                    let index2 = str.index(str.startIndex, offsetBy: 18)
                    string = String(str[index1...index2])
                    fileNameArray.append(string)
                } else if (exportType == "csvBarcode") {
                    let index1 = str.index(str.startIndex, offsetBy: 8)
                    let index2 = str.index(str.startIndex, offsetBy: 21)
                    string = String(str[index1...index2])
                    fileNameArray.append(string)
                } else if (exportType == "excelInven") {
                    let index1 = str.index(str.startIndex, offsetBy: 5)
                    let index2 = str.index(str.startIndex, offsetBy: 18)
                    string = String(str[index1...index2])
                    fileNameArray.append(string)
                } else if (exportType == "excelBarcode") {
                    let index1 = str.index(str.startIndex, offsetBy: 8)
                    let index2 = str.index(str.startIndex, offsetBy: 21)
                    string = String(str[index1...index2])
                    fileNameArray.append(string)
                }
            }
        }
        fileNameArray.sort(by: {(s1, s2) -> Bool in
            if (s1>s2) {
                return true
            }else{
                return false
            }
        })
        for str in fileNameArray {
            for string in arr {
                if (string.contains(str)) {
                    dataArray.append(string)
                }
            }
        }
        tableView.reloadData()
        AsReaderGUNManager.dismissGlobalHUD()
        CATransaction.commit()
    }
}

// MARK: - AsReaderGUNManagerDelegate
extension ExportTableViewController: AsReaderGUNManagerDelegate {
    func whenAsReaderGUNConnected(_ isConnected: Bool) {
        if isConnected == false {
            DispatchQueue.main.async {
                self.nowViewWillDisappear()
                self.dismiss(animated: true, completion: nil)
                Thread.sleep(forTimeInterval: 0.2)
                self.navigationController?.popToRootViewController(animated: true)
            }
        }
    }
}
