//
//  EpcMaskEditViewController.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/9.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class EpcMaskEditViewController: UIViewController {
    @IBOutlet private weak var offsetTextField: UITextField!
    @IBOutlet private weak var maskTextField: UITextField!
    @IBOutlet private weak var lengthTextField: UITextField!
    @IBOutlet private weak var pickerView: UIPickerView!
    @IBOutlet private weak var offsetPickerTopView: UIView!
    @IBOutlet private weak var lengthPickerTopView: UIView!
    private enum PickerViewTag: Int {
        case pickerViewOffset = 0
        case pickerViewLength = 1
    }
    private var asReaderGUNManager: AsReaderGUNManager! = AsReaderGUNManager.sharedAsReaderGUNManager
    private lazy var offsetPickerData: [String] = {
        var tmpArray: [String] = []
        for offset in bitData {
            tmpArray.append("\(offset) bit")
        }
        return tmpArray
    }()
    private lazy var lengthPickerData: [String] = {
        var tmpArray: [String] = []
        for offset in bitData {
            tmpArray.append("\(offset) bit")
        }
        return tmpArray
    }()
    private lazy var bitData: [String] = {
        return dataBit
    }()
    var selectMaskParam: AsSelectMaskEPCParam?
    override func viewDidLoad() {
        super.viewDidLoad()
        if let aSelectMaskParam = selectMaskParam {
            setOffset(getBitDataIndex(Int(aSelectMaskParam.offset)))
            setMask(selectMaskParam?.mask)
            setLength(getBitDataIndex(Int(aSelectMaskParam.length)))
        } else {
            selectMaskParam = AsSelectMaskEPCParam()
            setOffset(1)
            setLength(1)
        }
    }
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        asReaderGUNManager.asReaderGUNManagerDelegate = self
    }
    override func shouldPerformSegue(withIdentifier identifier: String, sender: Any?) -> Bool {
        if identifier == "BackToSource" {
            if let text = lengthTextField.text {
                if let row = lengthPickerData.firstIndex(of: text) {
                    let maskBit = Int(bitData[row]) ?? 0
                    if maskTextField.text?.count != maskBit / 4 {
                        let alertController = UIAlertController(title: "Error",
                                                                message: "Mask length is not valid",
                                                                preferredStyle: .alert)
                        let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                        alertController.addAction(okAction)
                        present(alertController, animated: true, completion: nil)
                        return false
                    }
                }
            }
        }
        return true
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    @IBAction func offsetBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewOffset.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        offsetPickerTopView.isHidden = false
        if let text = offsetTextField.text {
            if !text.isEmpty {
                if let row = offsetPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func maskBtnTapped(_ sender: UIButton) {
        let alertController = UIAlertController(title: "Mask:", message: "Please enter mask value.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .numberPad
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: { _ in
            self.setMask("")
        })
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            self.setMask(alertController.textFields?.first?.text)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction func lengthBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewLength.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        lengthPickerTopView.isHidden = false
        if let text = lengthTextField.text {
            if !text.isEmpty {
                if let row = lengthPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func pickerCloseBtnTapped(_ sender: UIButton) {
        hidePickerView()
    }
    @IBAction func offsetPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setOffset(idx)
        hidePickerView()
    }
    @IBAction func lengthPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setLength(idx)
        hidePickerView()
    }
}
// MARK: - UIPickerViewDelegate, UIPickerViewDataSource
extension EpcMaskEditViewController: UIPickerViewDelegate, UIPickerViewDataSource {
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewOffset {
                return bitData.count
            } else if pickerViewTag == .pickerViewLength {
                return lengthPickerData.count
            }
        }
        return 0
    }
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewOffset {
                return offsetPickerData[row]
            } else if pickerViewTag == .pickerViewLength {
                return lengthPickerData[row]
            }
        }
        return "None"
    }
}
// MARK: - UITextFieldDelegate
extension EpcMaskEditViewController: UITextFieldDelegate {
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        if string.isEmpty {
            return true
        }
        if "0123456789ABCDEFabcdef" .contains(string) {
            let newString = (textField.text as NSString?)?.replacingCharacters(in: range, with: string)
            textField.text = newString?.uppercased()
        }
        return false
    }
}
// MARK: - AsReaderGUNManagerDelegate
extension EpcMaskEditViewController: AsReaderGUNManagerDelegate {
    func whenAsReaderGUNConnected(_ isConnected: Bool) {
        if isConnected == true {
            DispatchQueue.main.async {
                self.viewDidAppear(true)
            }
        } else {
            DispatchQueue.main.async {
                self.navigationController?.popToRootViewController(animated: true)
            }
        }
    }
    func asReaderGUNOn(asReaderTriggerKeyEvent status: Bool) -> Bool {
        return false
    }
    func asReaderGUNOn(asReaderLeftModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
    func asReaderGUNOn(asReaderRightModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
}
// MARK: - Custom
extension EpcMaskEditViewController {
    func hidePickerView() {
        offsetPickerTopView.isHidden = true
        lengthPickerTopView.isHidden = true
        pickerView.isHidden = true
    }
    func getBitDataIndex(_ bit: Int) -> Int {
        return bitData.firstIndex(of: "\(bit)") ?? 0
    }
}
// MARK: - Setters
extension EpcMaskEditViewController {
    func setOffset(_ index: Int) {
        offsetTextField.text = offsetPickerData[index]
        selectMaskParam?.offset = Int32(bitData[index]) ?? 0
    }
    func setMask(_ mask: String?) {
        maskTextField.text = mask
        selectMaskParam?.mask = mask
    }
    func setLength(_ index: Int) {
        lengthTextField.text = lengthPickerData[index]
        selectMaskParam?.length = Int32(bitData[index]) ?? 0
    }
}
