//
//  RFMHelper.swift
//  AsReaderGUN
//
//  Created by Songxueqian on 2022/3/1.
//  Copyright © 2022 Asterisk. All rights reserved.
//

import UIKit

final class RFMHelper: NSObject {
    
    class func calculationTemp(_ sensCode: String?, calibration: String?) -> String {
        guard let sensCode: String = sensCode,let calibration: String = calibration else {
            return  ""
        }

        if (sensCode.isEmpty || calibration.isEmpty) {
            return ""
        }
        let newCalibration: String = calibration.uppercased()
        let calibBinaryData: String = RFMHelper.convertHexToBinary(newCalibration)
        print(String(format: " Sen Code1 : %@", calibBinaryData))
        let calibBinaryCode1: String = String(calibBinaryData.prefix(12))
        let calibBinaryTemp1: String = calibBinaryData[12, 11]
        let calibBinaryCode2: String = calibBinaryData[23, 12]
        let calibBinaryTemp2: String = calibBinaryData[35, 11]

        let calibDecCode1: NSNumber = RFMHelper.convertBinaryStringToDecimalNumber(calibBinaryCode1)
        let calibDecCode2: NSNumber = RFMHelper.convertBinaryStringToDecimalNumber(calibBinaryCode2)
        let calibDecTemp1: NSNumber = RFMHelper.convertBinaryStringToDecimalNumber(calibBinaryTemp1)
        let calibDecTemp2: NSNumber = RFMHelper.convertBinaryStringToDecimalNumber(calibBinaryTemp2)

        let calibCode1: Int =  calibDecCode1.intValue
        let calibCode2: Int =  calibDecCode2.intValue
        let calibTemp1: Int =  calibDecTemp1.intValue
        let calibTemp2: Int =  calibDecTemp2.intValue
        let code: Int       =  RFMHelper.convertHexStringToInt(sensCode)

        let temperatureVal: Int = Int((calibTemp2 - calibTemp1) / (calibCode2 - calibCode1))
        let temperatureVal2: Int = Int(temperatureVal * (code - calibCode1) + calibTemp1 - 800)
        let temperatureVal3: Float = Float(0.1 * Float(temperatureVal2))
        return String(format: "%.1f", temperatureVal3)
    }
    class func calculationSensorCode(_ sensCode: String?, tid: String?) -> String {
        guard let sensCode: String = sensCode else {
            return  ""
        }
        if (sensCode.isEmpty) {
            return ""
        }
        let newSensCode = String(sensCode.prefix(4))
        let code: Int = RFMHelper.convertHexStringToInt(newSensCode)
        return String(format: "%d", code)
    }
    class func convertHexToBinary(_ hexString: String) -> String {
        var returnString: String = String.init()
        for i in 0..<hexString.count {
            let lowHexString: String = hexString.lowercased()
            switch (lowHexString[i]) {
            case "0":
                returnString.append("0000")
                break
            case "1":
                returnString.append("0001")
                break
            case "2":
                returnString.append("0010")
                break
            case "3":
                returnString.append("0011")
                break
            case "4":
                returnString.append("0100")
                break
            case "5":
                returnString.append("0101")
                break
            case "6":
                returnString.append("0110")
                break
            case "7":
                returnString.append("0111")
                break
            case "8":
                returnString.append("1000")
                break
            case "9":
                returnString.append("1001")
                break
            case "a":
                returnString.append("1010")
                break;
            case "b":
                returnString.append("1011")
                break
            case "c":
                returnString.append("1100")
                break
            case "d":
                returnString.append("1101")
                break
            case "e":
                returnString.append("1110")
                break
            case "f":
                returnString.append("1111")
                break
            default:
                break
            }
        }
        return returnString;
    }
    class func convertBinaryStringToDecimalNumber(_ binaryString: String) -> NSDecimalNumber {
        var totalValue: Decimal = 0
        for i in 0..<binaryString.count {
            let aaa: NSString = NSString(string: binaryString)
            let bbb: unichar = aaa.character(at: binaryString.count - 1 - i) - 48
            let ccc: Decimal = Decimal(bbb)
            let ddd: Decimal = pow(2, i)
            let value: Decimal = ccc * ddd
            totalValue = totalValue + value
        }
        let c: NSDecimalNumber = NSDecimalNumber.init(decimal: totalValue)
        return c
    }
    class func convertHexStringToInt(_ hexString: String) -> Int {
        if hexString.isEmpty || hexString == "" {
            return 0
        }
        var outVal: UInt32 = 0
        Scanner(string: hexString).scanHexInt32(&outVal)
        return Int(outVal);
    }
}
extension String {
    /// String使用下标截取字符串
    /// string[index] 例如："abcdefg"[3] // c
    subscript (i:Int)->String{
        let startIndex = self.index(self.startIndex, offsetBy: i)
        let endIndex = self.index(startIndex, offsetBy: 1)
        return String(self[startIndex..<endIndex])
    }
    /// String使用下标截取字符串
    /// string[index..<index] 例如："abcdefg"[3..<4] // d
    subscript (r: Range<Int>) -> String {
        get {
            let startIndex = self.index(self.startIndex, offsetBy: r.lowerBound)
            let endIndex = self.index(self.startIndex, offsetBy: r.upperBound)
            return String(self[startIndex..<endIndex])
        }
    }
    /// String使用下标截取字符串
    /// string[index,length] 例如："abcdefg"[3,2] // de
    subscript (index:Int , length:Int) -> String {
        get {
            let startIndex = self.index(self.startIndex, offsetBy: index)
            let endIndex = self.index(startIndex, offsetBy: length)
            return String(self[startIndex..<endIndex])
        }
    }
    // 截取 从头到i位置
    func substring(to:Int) -> String{
        return self[0..<to]
    }
    // 截取 从i到尾部
    func substring(from:Int) -> String{
        return self[from..<self.count]
    }
}
