//
//  DatabaseManeger.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/6.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class DatabaseManeger: NSObject {
    private let databaseName = "database.db"
    private var dbQueue: FMDatabaseQueue!
    var insertOperation: OperationQueue!
    static let sharedDatabaseManeger = DatabaseManeger()
    override init() {
        super.init()
        _ = getDatebaseQueue()
        insertOperation = OperationQueue()
    }
    public func getDatebaseQueue() -> FMDatabaseQueue? {
        if dbQueue != nil {
            return dbQueue
        }
        let fileManager = FileManager.default
        let documentsPath = NSHomeDirectory() + "/Documents/"
        let writableDbPath = "\(documentsPath)\(databaseName)"
        let isHave = fileManager.fileExists(atPath: writableDbPath)
        if !isHave {
            guard let defaultDbPath = Bundle.main.path(forResource: "database", ofType: "db") else {
                return nil
            }
            do {
                try fileManager.copyItem(atPath: defaultDbPath, toPath: writableDbPath)
            } catch {
                return nil
            }
        }
        dbQueue = FMDatabaseQueue(path: writableDbPath)
        return dbQueue
    }

    public func deleteAll(asTagItemsFmdb fmdb: FMDatabase?) -> Bool {
        if fmdb == nil {
            print("FMDB ERROR")
        }
        let sql = "DELETE FROM AsTagItem"
        let result = fmdb?.executeUpdate(sql, withArgumentsIn: []) ?? false
        if result {
            print("DELETE SUCCESS")
            return true
        } else {
            print("DELETE ERROR")
            return false
        }
    }
    public func getAllAsTagItemsfmdb(_ fmdb: FMDatabase?) -> [Any]? {
        var array: [AsTagItem] = []
        guard let db = fmdb else {
            print("FMDB ERROR")
            return array
        }
        let sql = "SELECT * FROM AsTagItem"
        guard let set = try? db.executeQuery(sql, values: []) else {
            return array
        }
        while set.next() {
            let item = AsTagItem()
            item.tag = set.string(forColumn: "tag") ?? ""
            item.dateTime = set.string(forColumn: "datetime") ?? ""
            item.count = Int(set.int(forColumn: "count") )
            item.rssi = Float(set.double(forColumn: "rssi") )
            item.phase = Float(set.double(forColumn: "phase") )
            item.frequency = Float(set.double(forColumn: "frequency") )
            item.tid = set.string(forColumn: "tid") ?? ""
            array.append(item)
        }
        return array
    }
    public func updataOrAddSql(_ sql: String?, fmdb: FMDatabase?) -> Bool {
        if fmdb == nil {
            print("FMDB ERROR")
        }
        guard let replace = fmdb?.executeUpdate(sql!, withArgumentsIn: []) else {
            return false
        }
        if replace {
            print("REPLACE SUCCESS")
        } else {
            print("REPLACE ERROR")
        }
        return replace
    }
    func updataOrAdd(_ asTagItem: AsTagItem?, fmdb: FMDatabase?) -> Bool {
        if fmdb == nil {
            print("FMDB ERROR")
        }
        var replace: Bool?
        if  let aTag = asTagItem?.tag,
            let aCount = asTagItem?.count,
            let aRssi = asTagItem?.rssi,
            let aPhase = asTagItem?.phase,
            let aFrequency = asTagItem?.frequency,
            let aDateTime = asTagItem?.dateTime {
            let sql: String = "REPLACE INTO AsTagItem(tag,count,rssi,phase,frequency,datetime)VALUES ('\(aTag)','\(aCount)','\(aRssi)','\(aPhase)','\(aFrequency)','\(aDateTime)')"
            replace =  fmdb?.executeUpdate(sql, withArgumentsIn: [])
        }
        
        guard let aReplace = replace else {
            return false
        }
        
        if aReplace {
            print("REPLACE SUCCESS")
        } else {
            print("REPLACE ERROR")
        }
        return aReplace
    }
}
