//
//  VersionHandler.m
//  VersionCompareDemo
//
//  Created by mac on 2017/7/10.
//  Copyright © 2017年 macmrx. All rights reserved.
//

#import "VersionHandler.h"
#define ipaName @"AsReaderLR.ipa"

@implementation VersionHandler{
    NSString *downloadUrl;
    NSString *bundleVersion;
    NSString *bundleBuild;
    NSString *forceType;
}
static VersionHandler *sharedVersionHandler=nil;
+ (VersionHandler *)sharedVersionHandler{
    if (!sharedVersionHandler) {
        sharedVersionHandler=[[VersionHandler alloc]init];
    }
    return sharedVersionHandler;
}
- (instancetype)init{
    self = [super init];
    if (self) {
    }
    return self;
}
-(void)getServeVersionWithUrl:(NSString *)url{
    NSString *path = url;
    NSDictionary *dic=[[NSDictionary alloc]initWithContentsOfURL:[NSURL URLWithString:path]];
    NSArray *itemsArray=[dic objectForKey:@"items"];
    for (int i=0; i<[itemsArray count]; i++) {
        if ([itemsArray[i] isKindOfClass:[NSDictionary class]]) {
            NSDictionary *itemsDic=itemsArray[i];
            if ([itemsDic objectForKey:@"assets"]&&[itemsDic objectForKey:@"assets"]!=[NSNull null]) {
                if ([[itemsDic objectForKey:@"assets"]isKindOfClass:[NSArray class]]) {
                    NSArray *assetsArray=[itemsDic objectForKey:@"assets"];
                    for (int j=0; j<[assetsArray count]; j++) {
                        if ([assetsArray[j] isKindOfClass:[NSDictionary class]]) {
                            NSDictionary *assetsDic=assetsArray[j];
                            if ([assetsDic objectForKey:@"url_jp"]&&[assetsDic objectForKey:@"url_jp"]!=[NSNull null]&&[[self getCurrentLanguage] hasPrefix:@"ja"]){
                                downloadUrl =[assetsDic objectForKey:@"url_jp"];
                            }
                            if ([assetsDic objectForKey:@"url_en"]&&[assetsDic objectForKey:@"url_en"]!=[NSNull null]&&[[self getCurrentLanguage] hasPrefix:@"en"]){
                                downloadUrl =[assetsDic objectForKey:@"url_en"];
                            }
                            if ([assetsDic objectForKey:@"url_cn"]&&[assetsDic objectForKey:@"url_cn"]!=[NSNull null]&&[[self getCurrentLanguage] hasPrefix:@"zh-Hans"]){
                                downloadUrl =[assetsDic objectForKey:@"url_cn"];
                            }
                        }
                    }
                }
                if ([itemsDic objectForKey:@"metadata"]&&[itemsDic objectForKey:@"metadata"]!=[NSNull null]){
                    if ([itemsDic objectForKey:@"metadata"]&&[itemsDic objectForKey:@"metadata"]!=[NSNull null]){
                        if ([[itemsDic objectForKey:@"metadata"]isKindOfClass:[NSDictionary class]]) {
                            NSDictionary *metadataDic =[itemsDic objectForKey:@"metadata"];
                            if ([metadataDic objectForKey:@"bundle-version"]&&[metadataDic objectForKey:@"bundle-version"]!=[NSNull null]) {
                                bundleVersion=[metadataDic objectForKey:@"bundle-version"];
                            }
                            if ([metadataDic objectForKey:@"bundle-build"]&&[metadataDic objectForKey:@"bundle-build"]!=[NSNull null]) {
                                bundleBuild=[metadataDic objectForKey:@"bundle-build"];
                            }
                            if ([metadataDic objectForKey:@"ios_ver_force"]&&[metadataDic objectForKey:@"ios_ver_force"]!=[NSNull null]) {
                                forceType=[metadataDic objectForKey:@"ios_ver_force"];
                            }
                        }
                    }
                }
                
            }
        }
    }
    if (downloadUrl&&bundleVersion&&bundleBuild&&forceType) {
        if ([self isNeedDownloadApp]) {
            if (_versionHandlerDelegate&&[_versionHandlerDelegate respondsToSelector:@selector(UpdateUrl:forceType:)]) {
                [_versionHandlerDelegate UpdateUrl:downloadUrl forceType:forceType];
            }
        }
    }
}
-(BOOL)isNeedDownloadApp{
    NSDictionary *infoDictionary = [[NSBundle mainBundle] infoDictionary];
    NSString *app_Version = [infoDictionary objectForKey:@"CFBundleShortVersionString"];
//    NSString *app_build = [infoDictionary objectForKey:@"CFBundleVersion"];
    NSMutableArray *appVersionArray = [[NSMutableArray alloc]initWithArray:[app_Version componentsSeparatedByString:@"."]];
    NSMutableArray *serverVersionArray =[[NSMutableArray alloc]initWithArray:[bundleVersion componentsSeparatedByString:@"."]];
    if(appVersionArray.count > serverVersionArray.count){
        for (int i = (int)serverVersionArray.count; i<appVersionArray.count; i++) {
            [serverVersionArray addObject:@"0"];
        }
    }else{
        for (int i = (int)appVersionArray.count; i<serverVersionArray.count; i++) {
            [appVersionArray addObject:@"0"];
        }
    }
    if ([app_Version isEqualToString:bundleVersion]) {
        return NO;
//        if ([app_build isEqualToString:bundleBuild]) {
//            return NO;
//        }else{
//            if ([app_build rangeOfString:@"_"].location!=NSNotFound) {
//                NSArray *localBulidArray=[app_build componentsSeparatedByString:@"_"];
//                if ([localBulidArray[0]isEqualToString:bundleBuild]) {
//                    return NO;
//                }else{
//                    return [self compareBulidWithAppBuild:localBulidArray[0]];
//                }
//            }else{
//                if ([app_build isEqualToString:bundleBuild]) {
//                    return NO;
//                }else{
//                    return [self compareBulidWithAppBuild:app_build];
//                }
//            }
//        }
    }else{
        for (int i = 0; i< appVersionArray.count; i++) {
            NSInteger a = [[serverVersionArray objectAtIndex:i] integerValue];
            NSInteger b = [[appVersionArray objectAtIndex:i] integerValue];
            if (a > b) {
                return YES;
            }else if(a < b){
                return NO;
            }
        }
    }
    return NO;
}
-(BOOL)compareBulidWithAppBuild:(NSString *)build{
    NSMutableArray *appBuildArray = [[NSMutableArray alloc]initWithArray:[build componentsSeparatedByString:@"."]];
    NSMutableArray *serverBuildArray =[[NSMutableArray alloc]initWithArray:[bundleBuild componentsSeparatedByString:@"."]];
    if(appBuildArray.count > serverBuildArray.count){
        for (int i = (int)serverBuildArray.count; i<appBuildArray.count; i++) {
            [serverBuildArray addObject:@"0"];
        }
    }else{
        for (int i = (int)appBuildArray.count; i<serverBuildArray.count; i++) {
            [appBuildArray addObject:@"0"];
        }
    }
    for (int i = 0; i< appBuildArray.count; i++) {
        NSInteger a = [[serverBuildArray objectAtIndex:i] integerValue];
        NSInteger b = [[appBuildArray objectAtIndex:i] integerValue];
        if (a > b) {
            return YES;
        }else if(a < b){
            return NO;
        }
    }
    return NO;
}
- (NSString *)getCurrentLanguage
{
    NSArray *languages = [NSLocale preferredLanguages];
    NSString *currentLanguage = [languages objectAtIndex:0];
    return currentLanguage;
}
@end
