//
//  SystemSetting.h
//  AsReaderLR
//
//  Created by mac on 2017/8/7.
//  Copyright © 2017年 asterisk. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface SystemSetting : NSObject

+ (SystemSetting *)sharedSystemSetting;

- (void)asReaderGUNSetting;
- (void)RFIDSetting;
- (void)barcodeSetting;


- (void)setCustomPrefixSuffix:(BOOL)isPreSuffixOn;
- (BOOL)getCustomPrefixSuffix;

- (void)setBarcodeSettingSaveType:(BOOL)isTemporaryOn;
- (BOOL)getBarcodeSettingSaveTypeIsTemporary;


- (void)setNotFirstUsed:(BOOL)isFirst;
- (BOOL)getNotFirstUsed;

- (void)setBarcodeReScanTime:(int)barcodeReScanTime;
- (int)getBarcodeReScanTime;

- (void)setBuzzerTime:(int)buzzerTime;
- (int)getBuzzerTime;

- (void)setVibratorTime:(int)vibratorTime;
- (int)getVibratorTime;

- (void)setBuzzer:(int)buzzertType;
- (int)getBuzzer;

- (void)setVibrator:(int)vibratorType;
- (int)getVibrator;

- (void)setInventoryTime:(int)inventoryTime;
- (int)getInventoryTime;

- (void)setIdleTime:(int)idleTime;
- (int)getIdleTime;

- (void)setAutoOffTime:(int)autoOffTime;
- (int)getAutoOffTime;

- (void)setQValue:(int)qValue;
- (int)getQValue;

- (void)setAlgorithm:(int)algorithm;
- (int)getAlgorithm;

- (void)setMaxQ:(int)maxQValue;
- (int)getMaxQ;

- (void)setMinQ:(int)minQValue;
- (int)getMinQ;

- (void)setSleepTime:(int)sleepTimeValue;
- (int)getSleepTime;

- (void)setMaskTypeValue:(int)maskTypeValue;
- (int)getMaskTypeValue;

- (void)setLinkProfileValue:(int)linkProfileValue;
- (int)getLinkProfileValue;

- (void)setDefaultLinkProfileValue:(int)defaultLinkProfileValue;
- (int)getDefaultLinkProfileValue;

- (void)setOperationTime:(int)operationTime;
- (int)getOperationTime;


- (void)setPowerGain:(int)powerGain;
- (int)getPowerGain;

- (void)setInventorySession:(int)inventorySession;
- (int)getInventorySession;

- (void)setSessionFlag:(int)sessionFlag;
- (int)getSessionFlag;

- (void)setUseSelectionMask:(int)useSelectionMask;
- (int)getUseSelectionMask;

- (void)setContinuousMode:(BOOL)isContinuousMode;
- (BOOL)getContinuousMode;

- (void)setRssiMode:(BOOL)isRssiMode;
- (BOOL)getRssiMode;

- (void)setPropBarcodeMode:(BOOL)isPropBarcodeMode;
- (BOOL)getPropBarcodeMode;

- (void)setEpcMaskMatchMode:(BOOL)isEpcMaskMatchMode;
- (BOOL)getEpcMaskMatchMode;

- (void)setDisPlayPC:(BOOL)isDisplaypc;
- (BOOL)getDisPlayPC;


- (void)setLbtItemData:(NSArray *)lbtItemData;
- (NSArray *)getLbtItemData;

- (void)setRfidData:(NSArray *)rfidData;
- (NSArray *)getRfidData;

- (void)setBarcodeData:(NSArray *)barcodeData;
- (NSArray *)getBarcodeData;

- (void)setMapTags:(NSDictionary *)mapTags;
- (NSDictionary *)getMapTags;

- (void)setEpcMaskData:(NSArray *)epcMaskData;
- (NSArray *)getEpcMaskData;

- (void)setSelectionEpcMaskData:(NSArray *)selectionEpcMaskData;
- (NSArray *)getSelectionEpcMaskData;

- (void)setBarcodeParamData:(NSArray *)barcodeParamData;
- (NSArray *)getBarcodeParamData;


- (void)setThresHoldValue:(int)thresHoldValue;
- (int)getThresHoldValue;

//Robin
- (void)setMaskDataUpdate;
- (void)clearAllMaskData;

- (void)setTidLength:(int)length;
- (int)getTidLength;
- (void)setTidOn:(BOOL)isOn;
- (BOOL)getTidOn;

@end
