//
//  ExcelData.m
//  AsReaderLR
//
//  Created by mac on 2018/11/27.
//  Copyright © 2018年 asterisk. All rights reserved.
//

#import "ExcelData.h"
#import "AsTagItem.h"
#import "AsBarcodeItem.h"
#import <xlsxwriter/xlsxwriter.h>
@implementation ExcelData
+ (NSString *)filePath:(NSString *)fileName export:(ExportType)type{
    
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *path = [paths objectAtIndex:0];
    NSString *filePath = @"";
    switch (type) {
            case barcodeExportType:
        {
            filePath = [path stringByAppendingPathComponent:@"Barcode"];
        }
            break;
            case rfidExportType:
        {
            filePath = [path stringByAppendingPathComponent:@"RFID"];
        }
            break;
        default:
            break;
    }
    
    NSFileManager *fileManager = [NSFileManager defaultManager];
    if (![fileManager fileExistsAtPath:filePath]) {
        [fileManager createDirectoryAtPath:filePath withIntermediateDirectories:YES attributes:nil error:nil];
    }
    filePath = [filePath stringByAppendingPathComponent:fileName];
    return filePath;
}

//+ (BOOL) isFileExist:(NSString *)fileName {
//
//    NSFileManager *fileManager = [NSFileManager defaultManager];
//    BOOL result = [fileManager fileExistsAtPath:[self filePath:fileName]];
//    return result;
//}
//
//+ (void) deleteFileForFileName:(NSString *)fileName {
//
//    NSFileManager *fileManager = [NSFileManager defaultManager];
//    [fileManager removeItemAtPath:[self filePath:fileName] error:nil];
//}

+ (void) createExcelWithFileName:(NSString *)fileName export:(ExportType)type{
    
    NSFileManager *fileManager = [NSFileManager defaultManager];
    if (![fileManager createFileAtPath:[self filePath:fileName export:type]  contents:nil attributes:nil]) {
    }
};

+ (void) exportRfidExcel:(NSString *)fileName withArray:(NSMutableArray *)array export:(ExportType)type isEpc:(BOOL)isEpc isRssi:(BOOL)isRssiOn isTid:(BOOL)isTidOn{
    if (array.count == 0) {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
        [alert setMessage:@"RFID File Export Error"];
        [alert show];
        return;
    }
    
    // 创建新xlsx文件，路径需要转成c字符串
    lxw_workbook  *workbook  = workbook_new([[self filePath:fileName export:type] UTF8String]);
    // 创建sheet
    lxw_worksheet *worksheet = workbook_add_worksheet(workbook, NULL);
    // 添加格式
    lxw_format *format = workbook_add_format(workbook);
    
    //设置格式
    format_set_font_color(format, LXW_COLOR_BLACK);
    format_set_align(format, LXW_ALIGN_CENTER);// 水平居中
    format_set_align(format, LXW_ALIGN_VERTICAL_CENTER);//垂直居中

    lxw_format *liftformat = workbook_add_format(workbook);
    format_set_font_color(liftformat, LXW_COLOR_BLACK);
    format_set_align(liftformat, LXW_ALIGN_LEFT);// 水平居中
 
    lxw_format *rightFormat = workbook_add_format(workbook);
    format_set_font_color(rightFormat, LXW_COLOR_BLACK);
    format_set_align(rightFormat, LXW_ALIGN_RIGHT);// 水平居中
    
    // 设置列宽
    worksheet_set_column(worksheet, COLS("A:A"), 70, NULL);
    worksheet_set_column(worksheet, COLS("B:B"), 23, NULL);
    worksheet_set_column(worksheet, COLS("C:C"), 10, NULL);
    if(isRssiOn&isTidOn)
    {
      worksheet_set_column(worksheet, COLS("D:D"), 10, NULL);
      worksheet_set_column(worksheet, COLS("E:E"), 70, NULL);
    }
    else if(isRssiOn)
      worksheet_set_column(worksheet, COLS("D:D"), 10, NULL);
    else if(isTidOn)
      worksheet_set_column(worksheet, COLS("D:D"), 70, NULL);
    
    //第一行
    int cellIndex = 0;
    if (isEpc) {
        worksheet_write_string(worksheet, 0, cellIndex++, "pcepc hex", format);
    }else{
        worksheet_write_string(worksheet, 0, cellIndex++, "epc hex", format);
    }
    worksheet_write_string(worksheet, 0, cellIndex++, "time", format);
    
    worksheet_write_string(worksheet, 0, cellIndex++, "count", format);
    if(isRssiOn)
        worksheet_write_string(worksheet, 0, cellIndex++, "rssi", format);
    if(isTidOn)
        worksheet_write_string(worksheet, 0, cellIndex++, "tid", format);
    
    int i = 1;
    for (AsTagItem *item in array) {
        char tagChar[1000];
        char rssiChar[100];
        char tidChar[500];
        char dateTimeChar[1000];
        NSString *tagStr = @"";
        if (isEpc) {
            tagStr = item.tag;
        }else{
            tagStr = [item.tag substringFromIndex:TAG_PC_LENGTH];
        }
        NSString *rssiStr = [NSString stringWithFormat:@"%.2f",item.rssi];
        strcpy(tagChar,(char *)[tagStr UTF8String]);
        strcpy(dateTimeChar,(char *)[item.dateTime UTF8String]);
        strcpy(rssiChar,(char *)[rssiStr UTF8String]);
        strcpy(tidChar,(char *)[item.tid UTF8String]);
        cellIndex = 0;
        worksheet_write_string(worksheet, i, cellIndex++, tagChar, liftformat);
        worksheet_write_string(worksheet, i, cellIndex++, dateTimeChar, rightFormat);
        worksheet_write_number(worksheet, i, cellIndex++, item.count, rightFormat);
        if(isRssiOn)
            worksheet_write_string(worksheet, i, cellIndex++, rssiChar, rightFormat);
        
        if(isTidOn)
            worksheet_write_string(worksheet, i, cellIndex++, tidChar, liftformat);
        
        i ++;
    }
    workbook_close(workbook);
    
    UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
    [alert setMessage:@"RFID File Export Success"];
    [alert show];
}


+ (void) exportBarcodeExcel:(NSString *)fileName withArray:(NSMutableArray *)array export:(ExportType)type {
    if (array.count == 0) {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
        [alert setMessage:@"Barcode File Export Error"];
        [alert show];
        return;
    }
    
    // 创建新xlsx文件，路径需要转成c字符串
    lxw_workbook  *workbook  = workbook_new([[self filePath:fileName export:type] UTF8String]);
    // 创建sheet
    lxw_worksheet *worksheet = workbook_add_worksheet(workbook, NULL);
    // 添加格式
    lxw_format *format = workbook_add_format(workbook);
    
    //设置格式
    format_set_font_color(format, LXW_COLOR_BLACK);
    format_set_align(format, LXW_ALIGN_CENTER);// 水平居中
    format_set_align(format, LXW_ALIGN_VERTICAL_CENTER);//垂直居中
    
    
    lxw_format *liftformat = workbook_add_format(workbook);
    format_set_font_color(liftformat, LXW_COLOR_BLACK);
    format_set_align(liftformat, LXW_ALIGN_LEFT);// 水平居中
    
    lxw_format *rightFormat = workbook_add_format(workbook);
    format_set_font_color(rightFormat, LXW_COLOR_BLACK);
    format_set_align(rightFormat, LXW_ALIGN_RIGHT);// 水平居中
    
    // 设置列宽
    worksheet_set_column(worksheet, COLS("A:A"), 50, NULL);
    worksheet_set_column(worksheet, COLS("B:B"), 25, NULL);
    worksheet_set_column(worksheet, COLS("C:C"), 10, NULL);

    //第一行
    worksheet_write_string(worksheet, 0, 0, "barcode", format);
    worksheet_write_string(worksheet, 0, 1, "time", format);
    
    int i = 1;
    for (AsBarcodeItem *item in array) {
        char tagChar[65535];
        char dateTimeChar[1000];
        strcpy(tagChar,(char *)[item.barcode UTF8String]);
        strcpy(dateTimeChar,(char *)[item.dateTime UTF8String]);
        worksheet_write_string(worksheet, i, 0, tagChar, liftformat);
        worksheet_write_string(worksheet, i, 1, dateTimeChar, rightFormat);
        i ++;
    }
    workbook_close(workbook);
    
    UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
    [alert setMessage:@"Barcode File Export Success"];
    [alert show];
}

@end
