#import "UserData.h"

@implementation UserData

+ (void)setMaskType:(int)maskType {
    NSUserDefaults *prefs = [NSUserDefaults standardUserDefaults];
    [prefs setInteger:maskType forKey:@"maskType"];
    [prefs synchronize];
}

+ (int)getMaskType {
    NSUserDefaults *prefs = [NSUserDefaults standardUserDefaults];
    return (int)[prefs integerForKey:@"maskType"];
}

+ (void)setBatteryInterval:(NSString *)batteryInterval {
    int checkTime = [batteryInterval intValue];
    if(checkTime<10000)
        batteryInterval = @"10000";
    
    NSUserDefaults *prefs = [NSUserDefaults standardUserDefaults];
    [prefs setObject:batteryInterval forKey:@"batteryInterval"];
    [prefs synchronize];
}

+ (NSString *)getBatteryInterval {
    NSUserDefaults *prefs = [NSUserDefaults standardUserDefaults];
    NSString *batteryInterval = [prefs stringForKey:@"batteryInterval"];
    
    if (batteryInterval == nil || [batteryInterval isEqualToString:@""]) {
        batteryInterval = @"10000";
    }
    return batteryInterval;
}

+ (void)setIsUseKeyAction:(BOOL)isUseKeyAction {
    NSUserDefaults *prefs = [NSUserDefaults standardUserDefaults];
    [prefs setBool:isUseKeyAction forKey:@"isUseKeyAction"];
    [prefs synchronize];
}

+ (BOOL)getIsUseKeyAction {
    NSUserDefaults *prefs = [NSUserDefaults standardUserDefaults];
    return [prefs boolForKey:@"isUseKeyAction"];
}

@end
