package jp.co.asterisk.asreader.a3xd.demoapp.util.prefs;

import android.content.Context;
import android.content.SharedPreferences;

import androidx.preference.PreferenceManager;

public class SharedPreferencesHelper {

    private static final String PREF_KEY_ENCODING_TYPE = "PREF_KEY_ENCODING_TYPE";
    private static final String PREF_KEY_SESSION = "PREF_KEY_SESSION";
    private static final String PREF_KEY_SESSION_FLAG = "PREF_KEY_SESSION_FLAG";
    private static final String PREF_KEY_READER_BEEP = "PREF_KEY_READER_BEEP";
    private static final String PREF_KEY_READER_VIB = "PREF_KEY_READER_VIB";
    private static final String PREF_KEY_READER_LED = "PREF_KEY_READER_LED";
    private static final String PREF_KEY_READER_POWER_ON_BEEP = "PREF_KEY_READER_POWER_ON_BEEP";
    private static final String PREF_KEY_Q_VALUE = "PREF_KEY_Q_VALUE";
    private static final String PREF_KEY_DUTY_RATIO = "PREF_KEY_DUTY_RATIO";

    private static SharedPreferences prefs;

    public SharedPreferencesHelper(Context context) {
        prefs = PreferenceManager.getDefaultSharedPreferences(context);
    }

    public int getEncodingType() {
        return prefs.getInt(PREF_KEY_ENCODING_TYPE, 0);
    }

    public void setEncodingType(int encodingType) {
        prefs.edit().putInt(PREF_KEY_ENCODING_TYPE, encodingType).apply();
    }

    public boolean getReaderBeep() {
        return prefs.getBoolean(PREF_KEY_READER_BEEP, true);
    }

    public void setReaderBeep(boolean readerBeep) {
        prefs.edit().putBoolean(PREF_KEY_READER_BEEP, readerBeep).apply();
    }

    public boolean getReaderVib() {
        return prefs.getBoolean(PREF_KEY_READER_VIB, true);
    }

    public void setReaderVib(boolean readerVib) {
        prefs.edit().putBoolean(PREF_KEY_READER_VIB, readerVib).apply();
    }

    public boolean getReaderLed() {
        return prefs.getBoolean(PREF_KEY_READER_LED, true);
    }

    public void setReaderLed(boolean readerLed) {
        prefs.edit().putBoolean(PREF_KEY_READER_LED, readerLed).apply();
    }

    public boolean getReaderPowerOnBeep() {
        return prefs.getBoolean(PREF_KEY_READER_POWER_ON_BEEP, true);
    }

    public void setReaderPowerOnBeep(boolean readerPowerOnBeep) {
        prefs.edit().putBoolean(PREF_KEY_READER_POWER_ON_BEEP, readerPowerOnBeep).apply();
    }

    public int getSession() {
        return prefs.getInt(PREF_KEY_SESSION, 0);
    }

    public void setSession(int session) {
        prefs.edit().putInt(PREF_KEY_SESSION, session).apply();
    }

    public int getSessionFlag() {
        return prefs.getInt(PREF_KEY_SESSION_FLAG, 0);
    }

    public void setSessionFlag(int sessionFlag) {
        prefs.edit().putInt(PREF_KEY_SESSION_FLAG, sessionFlag).apply();
    }
    public int getQValue() {
        return prefs.getInt(PREF_KEY_Q_VALUE, 0);
    }

    public void setQValue(int q) {
        prefs.edit().putInt(PREF_KEY_Q_VALUE, q).apply();
    }
    public int getDuryRatio() {
        return prefs.getInt(PREF_KEY_DUTY_RATIO, 0);
    }

    public void setDuryRatio(int q) {
        prefs.edit().putInt(PREF_KEY_DUTY_RATIO, q).apply();
    }
}
