package jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting;

import android.os.Bundle;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentStopConditionsBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.demoapp.util.EditTextInputFilter;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.demoapp.R;

import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;

public class StopConditionsFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = StopConditionsFragment.class.getSimpleName();

    private FragmentStopConditionsBinding binding;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_StopConditionsFragment_to_HomeFragment);

        binding = FragmentStopConditionsBinding.inflate(inflater, container, false);

        int maxTag = AsReaderSDK.getInstance().getRFIDManager().getMaxTagValue();
        int maxTime = AsReaderSDK.getInstance().getRFIDManager().getMaxTimeValue();
        int repeatCycle = AsReaderSDK.getInstance().getRFIDManager().getRepeatCycleValue();

        binding.tagCountEditText.setFilters(new EditTextInputFilter[]{new EditTextInputFilter("0","255")});
        binding.elapsedTimeEditText.setFilters(new EditTextInputFilter[]{new EditTextInputFilter("0","255")});
        binding.inventoryRoundEditText.setFilters(new EditTextInputFilter[]{new EditTextInputFilter("0","65535")});

        binding.tagCountEditText.setText(String.valueOf(maxTag));
        binding.elapsedTimeEditText.setText(String.valueOf(maxTime));
        binding.inventoryRoundEditText.setText(String.valueOf(repeatCycle));

        binding.tagCountEditText.setOnFocusChangeListener(focusChangeListener);
        binding.elapsedTimeEditText.setOnFocusChangeListener(focusChangeListener);
        binding.inventoryRoundEditText.setOnFocusChangeListener(focusChangeListener);

        binding.getRoot().setFocusable(true);

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);

        setToolbar(true, getString(R.string.toolbar_title_stop_condition), getString(R.string.button_name_done));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);
        try {
            binding.getRoot().requestFocus();

            int maxTag = Integer.parseInt(binding.tagCountEditText.getText().toString());
            int maxTime = Integer.parseInt(binding.elapsedTimeEditText.getText().toString());
            int repeatCycle = Integer.parseInt(binding.inventoryRoundEditText.getText().toString());

            AsReaderSDK.getInstance().getRFIDManager().setTriggerStopCondition(maxTag, maxTime, repeatCycle);

            AsReaderSDK.getInstance().getRFIDManager().setMaxTagValue(maxTag);
            AsReaderSDK.getInstance().getRFIDManager().setMaxTimeValue(maxTime);
            AsReaderSDK.getInstance().getRFIDManager().setRepeatCycleValue(repeatCycle);

        } catch (NumberFormatException e) {
            e.printStackTrace();
            showToast(getString(R.string.error));
        }
    }

    private View.OnFocusChangeListener focusChangeListener = (View view, boolean hasFocus) -> {
        if (!hasFocus) {
            if (view == binding.tagCountEditText) {
                if (binding.tagCountEditText.getText().toString().equals("")) {
                    binding.tagCountEditText.setText("0");
                }
            } else if (view == binding.elapsedTimeEditText) {
                if (binding.elapsedTimeEditText.getText().toString().equals("")) {
                    binding.elapsedTimeEditText.setText("0");
                }
            } else if (view == binding.inventoryRoundEditText) {
                if (binding.inventoryRoundEditText.getText().toString().equals("")) {
                    binding.inventoryRoundEditText.setText("0");
                }
            }
        }
    };

    @Override
    public void onSetTriggerStopConditionSuccess() {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                showToast(getString(R.string.success), Toast.LENGTH_LONG);
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
