package jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.Toast;

import java.util.ArrayList;

import jp.co.asterisk.asreader.a3xd.demoapp.R;
import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentSessionBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;

public class SessionFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = SessionFragment.class.getSimpleName();

    private FragmentSessionBinding binding;

    private ArrayAdapter<String> adapter;
    private ArrayList<String> sessionList;

    private int session = 0;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_SessionFragment_to_HomeFragment);

        binding = FragmentSessionBinding.inflate(inflater, container, false);

        sessionList = new ArrayList<>();
        for (int i = 0; i < 4; i++) {
            sessionList.add("S" + i);
        }
        adapter = new ArrayAdapter<>(getContext(), R.layout.cell_setting_check, sessionList);

        binding.listView.setAdapter(adapter);
        binding.listView.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
        binding.listView.setItemChecked(getPreferencesHelper().getSession(), true);
        binding.listView.setOnItemClickListener((AdapterView<?> parent, View view, int position, long id) -> {
            session = position;
            getPreferencesHelper().setSession(session);
        });

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);
        AsReaderSDK.getInstance().getRFIDManager().getSession();

        setToolbar(true, getString(R.string.toolbar_title_session), getString(R.string.button_name_done));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);
        AsReaderSDK.getInstance().getRFIDManager().setSession(getPreferencesHelper().getSession());

    }

    @Override
    public void onSetSessionSuccess() {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                showToast(getString(R.string.success), Toast.LENGTH_LONG);
            });
        }
    }

    @Override
    public void onSessionReceived(int ses) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                binding.listView.setItemChecked(ses, true);
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
