package jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting;

import android.os.Bundle;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentOnOffTimeBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.demoapp.rfid.SerializableAsDeviceRfidFhLbtParam;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.demoapp.R;

import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;

public class OnOffTimeFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = OnOffTimeFragment.class.getSimpleName();

    public final static String ARGS_ON_OFF_TIME = "onOffTime";
    public final static String ARGS_PARAM = "param";

    private FragmentOnOffTimeBinding binding;

    private String onOffTime;

    private SerializableAsDeviceRfidFhLbtParam param;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            onOffTime = getArguments().getString(ARGS_ON_OFF_TIME);
            param = (SerializableAsDeviceRfidFhLbtParam)getArguments().getSerializable(ARGS_PARAM);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_OnOffTimeFragment_to_HomeFragment);

        binding = FragmentOnOffTimeBinding.inflate(inflater, container, false);

        if (onOffTime != null && onOffTime.length() > 0) {
            binding.onTimeEditText.setText(onOffTime.substring(0, onOffTime.indexOf("/")));
            binding.offTimeEditText.setText(onOffTime.substring(onOffTime.indexOf("/") + 1));
        } else {
            showToast("Not found RFID's data(On/Off Time)");
        }

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);

        setToolbar(true, getString(R.string.toolbar_title_on_off_time), getString(R.string.button_name_done));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);

        try {
            param.readtime = Integer.parseInt(binding.onTimeEditText.getText().toString());
            param.idletime = Integer.parseInt(binding.offTimeEditText.getText().toString());
            AsReaderSDK.getInstance().getRFIDManager().setFhLbtParam(
                    param.readtime,
                    param.idletime,
                    param.sensetime,
                    param.lbtlevel,
                    param.fhmode,
                    param.lbtmode,
                    param.cwmode
            );

        } catch (NumberFormatException e) {
            e.printStackTrace();
            showToast(getString(R.string.error));
        }
    }

    @Override
    public void onSetFhLbtParamSuccess() {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                showToast(getString(R.string.success), Toast.LENGTH_LONG);
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
