package jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting;

import android.os.Bundle;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentEncodingTypeBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.sdk.utility.EpcConverter;
import jp.co.asterisk.asreader.a3xd.demoapp.R;

import java.util.ArrayList;
import java.util.Arrays;

public class EncodingTypeFragment extends BaseFragment {

    private FragmentEncodingTypeBinding binding;

    private int type = 0;

    private ArrayAdapter<String> adapter;
    private ArrayList<String> typeList;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_EncodingTypeFragment_to_HomeFragment);

        binding = FragmentEncodingTypeBinding.inflate(inflater, container, false);

        typeList = new ArrayList<>(
                Arrays.asList(
                    EpcConverter.toTypeString(EpcConverter.HEX_STRING),
                    EpcConverter.toTypeString(EpcConverter.ASCII),
                    EpcConverter.toTypeString(EpcConverter.SGTIN96),
                    EpcConverter.toTypeString(EpcConverter.EAN13)));

        adapter = new ArrayAdapter<>(getContext(), R.layout.cell_setting_check, typeList);

        binding.listView.setAdapter(adapter);
        binding.listView.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
        binding.listView.setItemChecked(getPreferencesHelper().getEncodingType(), true);
        binding.listView.setOnItemClickListener((AdapterView<?> parent, View view, int position, long id) -> {
            type = position;
        });
        type = getPreferencesHelper().getEncodingType();
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();

        setToolbar(true, getString(R.string.toolbar_title_encoding_type), getString(R.string.button_name_done));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);
        getPreferencesHelper().setEncodingType(type);
        showToast(getString(R.string.success));
    }
}
