package jp.co.asterisk.asreader.a3xd.demoapp.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentMoreBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.rfid.custom.CustomSimpleMenuAdapter;
import jp.co.asterisk.asreader.a3xd.demoapp.R;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;

import java.util.ArrayList;
import java.util.Arrays;

public class MoreFragment extends BaseFragment {

    private enum MenuItem {
        SETTING("Setting"),
        HOPPING("Hopping"),
        REGION("Region"),
        INFO("Info"),
        READER_SETTING_ON_OFF("Reader Setting On/Off");

        private final String name;

        MenuItem(String name) {
            this.name = name;
        }

        public String getName() {
            return name;
        }
    }

    private FragmentMoreBinding binding;

    private CustomSimpleMenuAdapter adapter;
    private ArrayList<String> menuList;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_MoreFragment_to_HomeFragment);

        binding = FragmentMoreBinding.inflate(inflater, container, false);
        if (AsReaderSDK.getInstance().getDeviceManager().isM30SDevice()) {
            menuList = new ArrayList<>(Arrays.asList(
                    MenuItem.SETTING.getName(),
                    MenuItem.REGION.getName(),
                    MenuItem.INFO.getName(),
                    MenuItem.READER_SETTING_ON_OFF.getName()
            ));
        } else {
            menuList = new ArrayList<>(Arrays.asList(
                    MenuItem.SETTING.getName(),
                    MenuItem.HOPPING.getName(),
                    MenuItem.REGION.getName(),
                    MenuItem.INFO.getName(),
                    MenuItem.READER_SETTING_ON_OFF.getName()
            ));
        }
        adapter = new CustomSimpleMenuAdapter(getContext(), R.layout.simple_menu_list_item, menuList);
        binding.listView.setAdapter(adapter);
        binding.listView.setOnItemClickListener(itemClickListener);

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        setToolbar(true, getString(R.string.toolbar_title_more));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    private AdapterView.OnItemClickListener itemClickListener = (AdapterView<?> parent, View view, int position, long id) -> {
        if (AsReaderSDK.getInstance().getDeviceManager().isM30SDevice()) {
            if (position == MenuItem.SETTING.ordinal()) {
                navigate(this, R.id.action_MoreFragment_to_RfidSettingFragment);
            }
            else if (position + 1 == MenuItem.REGION.ordinal()) {
                navigate(this, R.id.action_MoreFragment_to_RegionFragment);
            }
            else if (position + 1 == MenuItem.INFO.ordinal()) {
                navigate(this, R.id.action_MoreFragment_to_InfoFragment);
            }
            else if (position + 1 == MenuItem.READER_SETTING_ON_OFF.ordinal()) {
                navigate(this, R.id.action_MoreFragment_to_ReaderSettingOnOffFragment);
            }
        } else {
            if (position == MenuItem.SETTING.ordinal()) {
                navigate(this, R.id.action_MoreFragment_to_RfidSettingFragment);
            }
            else if (position == MenuItem.HOPPING.ordinal()) {
                navigate(this, R.id.action_MoreFragment_to_HoppingFragment);
            }
            else if (position == MenuItem.REGION.ordinal()) {
                navigate(this, R.id.action_MoreFragment_to_RegionFragment);
            }
            else if (position == MenuItem.INFO.ordinal()) {
                navigate(this, R.id.action_MoreFragment_to_InfoFragment);
            }
            else if (position == MenuItem.READER_SETTING_ON_OFF.ordinal()) {
                navigate(this, R.id.action_MoreFragment_to_ReaderSettingOnOffFragment);
            }
        }
    };
}
