package jp.co.asterisk.asreader.a3xd.demoapp.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;

public class AlertDialogFragment extends DialogFragment {

    public interface AlertDialogFragmentListener {
        void OnClickPositiveButton();
        void OnClickNegativeButton();
    }

    private static String ARGS_TITLE = "ARGS_TITLE";
    private static String ARGS_MESSAGE = "ARGS_MESSAGE";
    private static String ARGS_POSITIVE_BUTTON_TEXT = "ARGS_POSITIVE_BUTTON_TEXT";
    private static String ARGS_NEGATIVE_BUTTON_TEXT = "ARGS_NEGATIVE_BUTTON_TEXT";

    private AlertDialogFragmentListener listener;

    public static AlertDialogFragment newInstance(
            String title,
            String message,
            String positiveButtonText
    ) {
        AlertDialogFragment dialogFragment = new AlertDialogFragment();
        Bundle args = new Bundle();
        args.putString(ARGS_TITLE, title);
        args.putString(ARGS_MESSAGE, message);
        args.putString(ARGS_POSITIVE_BUTTON_TEXT, positiveButtonText);
        dialogFragment.setArguments(args);
        return dialogFragment;
    }

    public static AlertDialogFragment newInstance(
            String title,
            String message,
            String positiveButtonText,
            Fragment fragment
    ) {
        AlertDialogFragment dialogFragment = new AlertDialogFragment();
        Bundle args = new Bundle();
        args.putString(ARGS_TITLE, title);
        args.putString(ARGS_MESSAGE, message);
        args.putString(ARGS_POSITIVE_BUTTON_TEXT, positiveButtonText);
        dialogFragment.setArguments(args);
        dialogFragment.setTargetFragment(fragment, 0);
        return dialogFragment;
    }

    public static AlertDialogFragment newInstance(
            String title,
            String message,
            String positiveButtonText,
            String negativeButtonText,
            Fragment fragment
    ) {
        AlertDialogFragment dialogFragment = new AlertDialogFragment();
        Bundle args = new Bundle();
        args.putString(ARGS_TITLE, title);
        args.putString(ARGS_MESSAGE, message);
        args.putString(ARGS_POSITIVE_BUTTON_TEXT, positiveButtonText);
        args.putString(ARGS_NEGATIVE_BUTTON_TEXT, negativeButtonText);
        dialogFragment.setArguments(args);
        dialogFragment.setTargetFragment(fragment, 0);
        return dialogFragment;
    }

    @NonNull
    @Override
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());

        String title = getArguments().getString(ARGS_TITLE);
        String message = getArguments().getString(ARGS_MESSAGE);
        String positiveButtonText = getArguments().getString(ARGS_POSITIVE_BUTTON_TEXT);
        String negativeButtonText = getArguments().getString(ARGS_NEGATIVE_BUTTON_TEXT);

        builder.setTitle(title);
        builder.setMessage(message);

        builder.setPositiveButton(positiveButtonText, (DialogInterface dialog, int which) -> {
            if (listener != null) {
                listener.OnClickPositiveButton();
            }
        });

        if (negativeButtonText != null) {
            builder.setNegativeButton(negativeButtonText, (DialogInterface dialog, int which) -> {
                if (listener != null) {
                    listener.OnClickNegativeButton();
                }
            });
        }

        AlertDialog dialog = builder.create();
        return dialog;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        Fragment targetFragment = this.getTargetFragment();
        try {
            if (targetFragment != null) {
                listener = (AlertDialogFragmentListener)targetFragment;
            }
        } catch (ClassCastException e) {
            throw new ClassCastException(e.toString());
        }
    }
}
