package jp.co.asterisk.asreader.a3xd.demoapp;

import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.navigation.fragment.NavHostFragment;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.ActivityMainBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.InfoFragment;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.ReaderSettingOnOffFragment;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting.RfidSettingFragment;
import jp.co.asterisk.asreader.a3xd.demoapp.util.prefs.SharedPreferencesHelper;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.manager.DeviceManagerCallback;

import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.HomeFragment;


public class MainActivity extends AppCompatActivity implements DeviceManagerCallback {
	private final String TAG = MainActivity.class.getSimpleName();

	private ActivityMainBinding binding;

	private SharedPreferencesHelper preferencesHelper;

	private boolean isPowerOn;

	public boolean isPowerOn() {
		return isPowerOn;
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		binding = ActivityMainBinding.inflate(getLayoutInflater());
		setContentView(binding.getRoot());

		setSupportActionBar(binding.toolbar);
		getSupportActionBar().setDisplayShowTitleEnabled(false);
		showBackButton(false);

		preferencesHelper = new SharedPreferencesHelper(getApplicationContext());

		AsReaderSDK.getInstance().getDeviceManager().setCallback(this);
		AsReaderSDK.getInstance().initialize(getApplicationContext());

		AsReaderSDK.getInstance().setLog(true);

		binding.rightButton.setOnClickListener(clickListener);
	}

	private Fragment getCurrentFragment() {
		Fragment navHostFragment = getSupportFragmentManager().findFragmentById(R.id.nav_host_fragment);
		return (navHostFragment != null) ? navHostFragment.getChildFragmentManager().getFragments().get(0) : null;
	}

	public SharedPreferencesHelper getPreferencesHelper() {
		return preferencesHelper;
	}

	public void setVisibilityOtgLogo(int visibility) {
		binding.otgLogoImageView.setVisibility(visibility);
	}

	private View.OnClickListener clickListener = (View v) -> {
		Fragment fragment = getCurrentFragment();

		if (fragment instanceof HomeFragment) {
			if (AsReaderSDK.getInstance().getDeviceManager().isOpen()) {
				AsReaderSDK.getInstance().getRFIDManager().stopDecode();
				navigate(fragment, R.id.action_HomeFragment_to_MoreFragment);
				return;
			}

		} else if (fragment instanceof BaseFragment) {
			((BaseFragment)fragment).onClickRightButton(v);
		}
	};

	@Override
	protected void onUserLeaveHint() {
		super.onUserLeaveHint();
		Fragment fragment = getCurrentFragment();
		((BaseFragment)fragment).onUserLeaveHint();
	}

	@Override
	public void onBackPressed() {
		Fragment fragment = getCurrentFragment();
		if (fragment instanceof HomeFragment) {
			((HomeFragment) fragment).onBackPressed();
		} else {
			NavHostFragment.findNavController(fragment).popBackStack();
		}
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		int id = item.getItemId();
		if (id == android.R.id.home) {
			Fragment currentFragment = getCurrentFragment();
			NavHostFragment.findNavController(currentFragment).popBackStack();
		}

		return super.onOptionsItemSelected(item);
	}

	public void navigate(Fragment fragment, int resId) {
		NavHostFragment.findNavController(fragment).navigate(resId);
	}

	public void navigate(Fragment fragment, int resId, Bundle args) {
		NavHostFragment.findNavController(fragment).navigate(resId, args);
	}


	public void showToast(String message, int duration) {
		Toast.makeText(getApplicationContext(), message, duration).show();
	}

	public void showBackButton(boolean show) {
		getSupportActionBar().setDisplayShowHomeEnabled(show);
		getSupportActionBar().setDisplayHomeAsUpEnabled(show);
	}

	public void setVisibilityRightButton(int visibility) {
		binding.rightButton.setVisibility(visibility);
	}

	public void setVisibilityOtgLogoImage(int visibility) {
		binding.otgLogoImageView.setVisibility(visibility);
	}

	public void setRightButtonText(String text) {
		binding.rightButton.setText(text);
	}

	public void setTitleText(String text) {
		binding.titleTextView.setText(text);
	}

	public void setTitleTextSize(float size) {
		binding.titleTextView.setTextSize(size);
	}

	public void setRightButtonEnabled(boolean enabled) {
		binding.rightButton.setEnabled(enabled);
	}

    public void setRightButtonTextColor(int color) {
        binding.rightButton.setTextColor(ContextCompat.getColor(getApplicationContext(), color));
    }

	@Override
	public void onConnect(boolean isConnect) {
		if (!isConnect) {
			isPowerOn = false;
		}
		Fragment fragment = getCurrentFragment();
		if (fragment instanceof BaseFragment) {
			((BaseFragment) fragment).onConnect(isConnect);
		}
	}

	@Override
	public void onBatteryStateReceived(int dest, int charging) {
		runOnUiThread(() -> {
			Fragment fragment = getCurrentFragment();
			if (fragment instanceof HomeFragment) {
				((HomeFragment) fragment).onBatteryStateReceived(dest, charging);
			}
		});
	}

	@Override
	public void onReaderInfoReceived(int onTime, int offTime, int senseTime,
									 int lbtLevel, int fhEnable, int lbtEnable,
									 int cwEnable, int power, int minPower, int maxPower) {
		runOnUiThread(() -> {
			Fragment fragment = getCurrentFragment();
			if (fragment instanceof RfidSettingFragment) {
				((RfidSettingFragment) fragment).onReaderInfoReceived(onTime, offTime, senseTime,
						lbtLevel, fhEnable, lbtEnable, cwEnable, power, minPower, maxPower);
			}
		});
	}

	@Override
	public void onReaderAboutInfo(String model, String hwVersion, String fwVersion, byte region) {
		runOnUiThread(() -> {
			Fragment fragment = getCurrentFragment();
			if (fragment instanceof InfoFragment) {
				((InfoFragment) fragment).onReaderAboutInfo(model, hwVersion, fwVersion, region);
			}
		});
	}

	@Override
	public void onReceivedRFIDModuleVersion(String versionInfo) {
		runOnUiThread(() -> {
			Fragment fragment = getCurrentFragment();
			if (fragment instanceof InfoFragment) {
				((InfoFragment) fragment).onReceivedRFIDModuleVersion(versionInfo);
			}
		});
	}

	@Override
	public void onCompletedPreparation(boolean isPowerOn) {
		this.isPowerOn = isPowerOn;
		runOnUiThread(() -> {
			Fragment fragment = getCurrentFragment();
			if (fragment instanceof HomeFragment) {
				((HomeFragment) fragment).onCompletedPreparation(isPowerOn);
			}
		});
	}

	@Override
	public void onSetReaderSettingSuccess() {
		runOnUiThread(() -> {
			Fragment fragment = getCurrentFragment();
			if (fragment instanceof ReaderSettingOnOffFragment) {
				((ReaderSettingOnOffFragment) fragment).onSetReaderSettingSuccess();
			}
		});
	}

	@Override
	public void onDeviceManagerError(String message) {
		runOnUiThread(() -> {
			showToast(message, Toast.LENGTH_LONG);
		});
	}
}
