//
//  System.m
//
//  Created by mac on 2018/12/20.
//  Copyright © 2018年 zyl. All rights reserved.
//

#import "System.h"
@implementation System{
    NSUserDefaults *_userDefaults;
}
static System * _sharedSystem;
+ (System *)sharedSystem{
    if (!_sharedSystem) {
        _sharedSystem = [[System alloc] init];
    }
    return _sharedSystem;
}
- (instancetype)init
{
    self = [super init];
    if (self) {
        _userDefaults = [NSUserDefaults standardUserDefaults];
        if (![self getIsFirstUsed]) {
            [self setIsFirstUsed:@"YES"];
            [self setStopTime:@"10"];
            [self setPort:@"9600"];
            [self setConnectMethod:ConnectMethod_TCP];
        }
    }
    return self;
}
- (void)setIsFirstUsed:(NSString *)used{
    [_userDefaults setValue:used forKey:@"isFirstUsed"];
    [_userDefaults synchronize];
}
- (NSString *)getIsFirstUsed{
    return  [_userDefaults valueForKey:@"isFirstUsed"];
}
- (ConnectMethod)getConnectMethod{
    return [_userDefaults integerForKey:@"connectMethod"];
}
- (void)setConnectMethod:(ConnectMethod)method{
    [_userDefaults setInteger:method forKey:@"connectMethod"];
    [_userDefaults synchronize];
}
- (void)setIp:(NSString *)ip{
    [_userDefaults setValue:ip forKey:@"ip"];
    [_userDefaults synchronize];
}
- (NSString *)getIp{
    return [_userDefaults valueForKey:@"ip"]?:@"";
}
- (void)setPort:(NSString *)port{
    [_userDefaults setValue:port forKey:@"port"];
    [_userDefaults synchronize];
}
- (NSString *)getPort{
    return [_userDefaults valueForKey:@"port"]?:@"9600";
}
- (NSString *)getMQTTIp{
    return  [_userDefaults valueForKey:@"ipMQTT"]?:@"";
}
- (void)setMQTTIp:(NSString *)ip{
    [_userDefaults setValue:ip forKey:@"ipMQTT"];
    [_userDefaults synchronize];
}
- (NSString *)getMQTTPort{
    return  [_userDefaults valueForKey:@"portMQTT"]?:@"1883";
}
- (void)setMQTTPort:(NSString *)port{
    [_userDefaults setValue:port forKey:@"portMQTT"];
    [_userDefaults synchronize];
}
- (void)setStopTime:(NSString *)time{
    [_userDefaults setValue:time forKey:@"time"];
    [_userDefaults synchronize];
}
- (NSString *)getStopTime{
    return [_userDefaults valueForKey:@"time"]?:@"";
}
- (void)setSubscribeRFIDTopic:(BOOL)subscribe{
    [_userDefaults setBool:subscribe forKey:@"subscribe"];
    [_userDefaults synchronize];
}
- (BOOL)getSubscribeRFIDTopic{
    return [_userDefaults boolForKey:@"subscribe"];
}
- (BOOL)getHIDStatus{
    return [_userDefaults boolForKey:@"hidStatus"];
}
- (void)setHIDStatus:(BOOL)hidStatus{
    [_userDefaults setBool:hidStatus forKey:@"hidStatus"];
    [_userDefaults synchronize];
}
@end
