//
//  SettingListViewController.m
//  ASR033W
//
//  Created by mac on 2020/11/20.
//

#import "SettingListViewController.h"
#import "ASR033W.h"
#import "Utils.h"

@interface SettingListViewController ()<ASR033WDelegate, UITextViewDelegate>
@property (strong, nonatomic) IBOutlet UITextView *receiveTextView;
@property (strong, nonatomic) IBOutlet UITextView *sendTextView;
@end

@implementation SettingListViewController{
    ASR033W *asr033w;
    NSMutableString *dataString;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    dataString = [[NSMutableString alloc] init];
    asr033w = [ASR033W sharedInstance];
    self.receiveTextView.layer.masksToBounds = YES;
    self.receiveTextView.layer.borderWidth = 1;
    self.receiveTextView.layer.borderColor = [[UIColor blackColor] CGColor];
    self.sendTextView.layer.masksToBounds = YES;
    self.sendTextView.layer.borderWidth = 1;
    self.sendTextView.layer.borderColor = [[UIColor blackColor] CGColor];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
- (IBAction)onClickSendButton:(UIButton *)sender {
    if ([self.sendTextView.text isEqualToString:@""]) {
        return;
    }
    NSString *value = self.sendTextView.text;
    value = [value stringByReplacingOccurrencesOfString:@" " withString:@""];
    NSData *data = [value hexStringToBytes];
    [asr033w sendData:data];
}
- (IBAction)onClickClearButton:(UIButton *)sender {
    dataString = [NSMutableString string];
    self.receiveTextView.text = @"";
}
#pragma mark - UITextViewDelegate
- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text {
    if ([text isEqualToString:@"\n"]) {
        [textView resignFirstResponder];
        return NO;
    }
    return YES;
}
#pragma mark - ASR033WDelegate
- (void)receivedASR033WNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
- (void)receivedASR033WData:(NSData *)data {
    NSMutableString *tmp = [[NSMutableString alloc] init];
    unsigned char *ptr= (unsigned char*) [data bytes];
    for(int i = 0; i < data.length; i++) {
        [tmp appendFormat:@"%02X", *ptr++ & 0xFF ];
    }
    NSString *barcode = [[NSString alloc] initWithData:data encoding:NSASCIIStringEncoding];
    if (dataString == nil || [@"" isEqualToString:dataString]) {
        [dataString appendString:barcode];
        [dataString appendString:[NSString stringWithFormat:@"DATA:%@",tmp]];
    } else {
        [dataString appendString:@"\n"];
        [dataString appendString:@"\n"];
        [dataString appendString:barcode];
        [dataString appendString:[NSString stringWithFormat:@"DATA:%@",tmp]];
    }
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        self.receiveTextView.text = self->dataString;
    }];
}
#pragma mark - System
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    [self.view endEditing:YES];
}
@end
