//
//  ReaderTimeViewController.m
//  ASR033W
//
//  Created by mac on 2020/11/30.
//

#import "ReaderTimeViewController.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import <SVProgressHUD/SVProgressHUD.h>
#import "Utils.h"

@interface ReaderTimeViewController ()<ASR033WDelegate, UITextFieldDelegate>
@property (strong, nonatomic) IBOutlet UITextField *textField;
@end

@implementation ReaderTimeViewController
{
    ASR033W *asr033w;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    asr033w = [ASR033W sharedInstance];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
    [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
    [SVProgressHUD showWithStatus:@"Reader time"];
    [asr033w getReaderTime];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
#pragma mark - ASR033WDelegate
- (void)ASR033W:(ASR033W *)ASR033W receivedReaderTime:(NSString *)readerTime {
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
    [SVProgressHUD dismiss];
    self.textField.text = readerTime;
}
- (void)ASR033W:(ASR033W *)ASR033W receivedSetReaderTimeStatus:(ASR033WExecutionStatus)statusCode {
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
    [SVProgressHUD dismiss];
    NSString *failedString = [ASR033W getMessageWithResultCode:statusCode];
    [Utils showAlert:@"" message:failedString];
}
- (void)ASR033W:(ASR033W *)ASR033W changeNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
#pragma mark - UITextFieldDelegate
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    [textField resignFirstResponder];
    return YES;
}
#pragma mark - Action
- (IBAction)onClickDoneBarItem:(UIBarButtonItem *)sender {
    [self.view endEditing:YES];
    if (self.textField.text.length <= 0) {
        return;
    }
    long time = [self totalSecondsFormatted:self.textField.text];
    if (time == 0) {
        return;
    }
    [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
    [SVProgressHUD showWithStatus:@"Set reader time"];
    [asr033w setReaderTime:time];
}
#pragma mark - System
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    [self.view endEditing:YES];
}
#pragma mark - Private
- (void)dismissHUD {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        [SVProgressHUD dismiss];
    }];
}
- (long)totalSecondsFormatted:(NSString *)time{
    NSDateFormatter *format = [[NSDateFormatter alloc] init];
    format.timeZone = [NSTimeZone systemTimeZone];
    format.dateFormat = @"yyyy.MM.dd HH:mm:ss";
    NSDate *date = [format dateFromString:time];
    if (date == nil) {
        format.dateFormat = @"yyyy.MM.dd";
        date = [format dateFromString:time];
        if (date == nil) {
            format.dateFormat = @"yyyy.MM.dd HH:mm:ss";
            date = [format dateFromString:[NSString stringWithFormat:@"%@ %@", [self getCurrentDate], time]];
        }
    }
    return date.timeIntervalSince1970;
}
- (NSString *)getCurrentDate {
    NSDate *date = [NSDate date];
    NSDateFormatter *format = [[NSDateFormatter alloc] init];
    format.timeZone = [NSTimeZone systemTimeZone];
    format.dateFormat = @"yyyy.MM.dd";
    NSString *today = [format stringFromDate:date];
    return today;
}
@end
