//
//  EthernetMacViewController.m
//  ASR033W
//
//  Created by mac on 2020/11/30.
//

#import "EthernetMacViewController.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import <SVProgressHUD/SVProgressHUD.h>

@interface EthernetMacViewController ()<ASR033WDelegate>
@property (strong, nonatomic) IBOutlet UITextField *macTextField;
@end

@implementation EthernetMacViewController
{
    ASR033W *asr033w;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    self.macTextField.userInteractionEnabled = NO;
    asr033w = [ASR033W sharedInstance];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
    [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
    [SVProgressHUD showWithStatus:@"Ethernet Mac"];
    [asr033w getReaderEthernetMacAddress];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
#pragma mark - ASR033WDelegate
- (void)ASR033W:(ASR033W *)ASR033W receivedReaderEthernetMACAddress:(NSString *)ethernetMACAddress {
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
    [SVProgressHUD dismiss];
    self.macTextField.text = ethernetMACAddress;
}
- (void)ASR033W:(ASR033W *)ASR033W changeNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
#pragma mark - Private
- (void)dismissHUD {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        [SVProgressHUD dismiss];
    }];
}
@end
