//
//  EthernetIPViewController.m
//  ASR033W
//
//  Created by mac on 2020/12/1.
//

#import "EthernetIPViewController.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import <ASR033WSDK/ASR033W.h>
#import <SVProgressHUD/SVProgressHUD.h>
#import "Utils.h"

@interface EthernetIPViewController ()<ASR033WDelegate, UITextFieldDelegate>
@property (strong, nonatomic) IBOutlet UISegmentedControl *ipSegment;
@property (strong, nonatomic) IBOutlet UITextField *ipTextField;
@property (strong, nonatomic) IBOutlet UITextField *subnetMaskTextField;
@property (strong, nonatomic) IBOutlet UITextField *gateWayTextField;
@property (strong, nonatomic) IBOutlet UITextField *preDNSTextField;
@property (strong, nonatomic) IBOutlet UITextField *altDNSTextField;
@end

@implementation EthernetIPViewController
{
    ASR033W *asr033w;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    asr033w = [ASR033W sharedInstance];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
    [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
    [SVProgressHUD showWithStatus:@"Ethernet IP"];
    [asr033w getReaderEthernetIP];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
#pragma mark - ASR033WDelegate
- (void)ASR033W:(ASR033W *)ASR033W receivedReaderEthernetIP:(NSString *)ip subnetMask:(NSString *)subnetMask defaultGateway:(NSString *)defaultGateway preferredDNS:(NSString *)preferredDNS alternateDNS:(NSString *)alternateDNS automaticIP:(BOOL)automaticIP {
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
    [SVProgressHUD dismiss];
    self.ipTextField.text = ip;
    self.subnetMaskTextField.text = subnetMask;
    self.gateWayTextField.text = defaultGateway;
    self.preDNSTextField.text = preferredDNS;
    self.altDNSTextField.text = alternateDNS;
    if (automaticIP) {
        [self.ipSegment setSelectedSegmentIndex:0];
    } else {
        [self.ipSegment setSelectedSegmentIndex:1];
    }
    if (automaticIP) {
        self.ipTextField.userInteractionEnabled = YES;
        self.subnetMaskTextField.userInteractionEnabled = YES;
        self.gateWayTextField.userInteractionEnabled = YES;
        self.preDNSTextField.userInteractionEnabled = YES;
        self.altDNSTextField.userInteractionEnabled = YES;
        self.ipTextField.textColor = [UIColor blackColor];
        self.subnetMaskTextField.textColor = [UIColor blackColor];
        self.gateWayTextField.textColor = [UIColor blackColor];
        self.preDNSTextField.textColor = [UIColor blackColor];
        self.altDNSTextField.textColor = [UIColor blackColor];
    } else {
        self.ipTextField.userInteractionEnabled = NO;
        self.subnetMaskTextField.userInteractionEnabled = NO;
        self.gateWayTextField.userInteractionEnabled = NO;
        self.preDNSTextField.userInteractionEnabled = NO;
        self.altDNSTextField.userInteractionEnabled = NO;
        self.ipTextField.textColor = [UIColor lightGrayColor];
        self.subnetMaskTextField.textColor = [UIColor lightGrayColor];
        self.gateWayTextField.textColor = [UIColor lightGrayColor];
        self.preDNSTextField.textColor = [UIColor lightGrayColor];
        self.altDNSTextField.textColor = [UIColor lightGrayColor];
    }
}
- (void)ASR033W:(ASR033W *)ASR033W receivedSetEthernetIPStatus:(ASR033WExecutionStatus)statusCode {
}
- (void)ASR033W:(ASR033W *)ASR033W changeNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
#pragma mark - Action
- (IBAction)onClickDoneBarItem:(UIBarButtonItem *)sender {
    [self.view endEditing:YES];
    if (self.ipTextField.text.length == 0 || self.subnetMaskTextField.text.length == 0 || self.gateWayTextField.text.length == 0 || self.preDNSTextField.text.length == 0 || self.altDNSTextField.text.length == 0) {
        return;
    }
    [SVProgressHUD showWithStatus:@"Set Ethernet IP"];
    [asr033w setReaderEthernetIP:self.ipTextField.text subnetMask:self.subnetMaskTextField.text defaultGateway:self.gateWayTextField.text preferredDNS:self.preDNSTextField.text alternateDNS:self.altDNSTextField.text automaticIP:self.ipSegment.selectedSegmentIndex];
    [SVProgressHUD dismiss];
}
- (IBAction)onClickIPSegment:(UISegmentedControl *)sender {
    if (sender.selectedSegmentIndex == 0) {
        self.ipTextField.userInteractionEnabled = YES;
        self.subnetMaskTextField.userInteractionEnabled = YES;
        self.gateWayTextField.userInteractionEnabled = YES;
        self.preDNSTextField.userInteractionEnabled = YES;
        self.altDNSTextField.userInteractionEnabled = YES;
        self.ipTextField.textColor = [UIColor blackColor];
        self.subnetMaskTextField.textColor = [UIColor blackColor];
        self.gateWayTextField.textColor = [UIColor blackColor];
        self.preDNSTextField.textColor = [UIColor blackColor];
        self.altDNSTextField.textColor = [UIColor blackColor];
    } else {
        self.ipTextField.userInteractionEnabled = NO;
        self.subnetMaskTextField.userInteractionEnabled = NO;
        self.gateWayTextField.userInteractionEnabled = NO;
        self.preDNSTextField.userInteractionEnabled = NO;
        self.altDNSTextField.userInteractionEnabled = NO;
        self.ipTextField.textColor = [UIColor lightGrayColor];
        self.subnetMaskTextField.textColor = [UIColor lightGrayColor];
        self.gateWayTextField.textColor = [UIColor lightGrayColor];
        self.preDNSTextField.textColor = [UIColor lightGrayColor];
        self.altDNSTextField.textColor = [UIColor lightGrayColor];
    }
}
#pragma mark - UITextFieldDelegate
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    [textField resignFirstResponder];
    return YES;
}
#pragma mark - System
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    [self.view endEditing:YES];
}
#pragma mark - Private
- (void)dismissHUD {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        [SVProgressHUD dismiss];
    }];
}
@end
