//
//  BasicSetViewController.m
//  ASR033W
//
//  Created by mac on 2020/12/2.
//

#import "BasicSetViewController.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import "System.h"
#import "Utils.h"
#import <SVProgressHUD/SVProgressHUD.h>

@interface BasicSetViewController ()<ASR033WDelegate, UITableViewDelegate, UITableViewDataSource>
@property (weak, nonatomic) IBOutlet UITableView *tableView;
@property (strong, nonatomic) IBOutlet UIButton *factoryResetButton;
@property (strong, nonatomic) IBOutlet UIButton *restartButton;
@end

@implementation BasicSetViewController
{
    ASR033W *asr033w;
    System *system;
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    system = [System sharedSystem];
    asr033w = [ASR033W sharedInstance];
    self.tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
    self.factoryResetButton.layer.masksToBounds = YES;
    self.factoryResetButton.layer.cornerRadius = 5;
    self.restartButton.layer.masksToBounds = YES;
    self.restartButton.layer.cornerRadius = 5;
}
- (IBAction)onClickFactoryRestButton:(UIButton *)sender {
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"Factory reset" message:nil preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *ok = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self performSelector:@selector(dismissFRHUD) withObject:nil afterDelay:10];
        [SVProgressHUD showWithStatus:@"Factory reset"];
        [self->asr033w factoryReset];
    }];
    UIAlertAction *cancel = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:nil];
    [alert addAction:ok];
    [alert addAction:cancel];
    [self presentViewController:alert animated:YES completion:nil];
}
- (IBAction)onClickRestartButton:(UIButton *)sender {
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"Restart the device" message:nil preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *ok = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self performSelector:@selector(dismissRDHUD) withObject:nil afterDelay:35];
        [SVProgressHUD showWithStatus:@"Restart device"];
        [self->asr033w restartDevice];
    }];
    UIAlertAction *cancel = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:nil];
    [alert addAction:ok];
    [alert addAction:cancel];
    [self presentViewController:alert animated:YES completion:nil];}
#pragma mark - Table view data source
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 1;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    NSString *cellIdentifier = @"tableViewCell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
    if(!cell){
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:cellIdentifier];
    }
    cell.textLabel.text = @"Information";
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [self performSegueWithIdentifier:@"InformationID" sender:nil];
}
#pragma mark - ASR033WDelegate
- (void)ASR033W:(ASR033W *)ASR033W receivedFactoryResetStatus:(ASR033WExecutionStatus)statusCode {
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissFRHUD) object:nil];
    [SVProgressHUD dismiss];
    NSString *failedString = [asr033w getMessageWithResultCode:statusCode];
    [Utils showAlert:@"" message:failedString];
}
- (void)ASR033W:(ASR033W *)ASR033W changeNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
#pragma mark - Private
- (void)dismissFRHUD {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        [SVProgressHUD dismiss];
    }];
}
- (void)dismissRDHUD {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        [SVProgressHUD dismiss];
        [[NSNotificationCenter defaultCenter] postNotificationName:@"RestartDevice" object:nil];
        [self.navigationController popToRootViewControllerAnimated:YES];
    }];
}
@end
