#import "ASR033WUtility.h"
#import "ASR033WDefine.h"

@implementation ASR033WUtility

+ (NSString *)dump:(NSData *)data {
    char* dump = (char*)data.bytes;
    NSMutableString *output = [[NSMutableString alloc] init];
    for (int i = 0; i < data.length; i++) {
        if (output.length > 0)
            [output appendString:@" "];
        [output appendFormat:@"%02X", (unsigned char)dump[i]];
    }
    return output;
}

+ (NSString *)getHexString:(NSData *)data {
    char* dump = (char*)data.bytes;
    NSMutableString *output = [[NSMutableString alloc] init];
    for (int i = 0; i < data.length; i++) {
        [output appendFormat:@"%02X", (unsigned char)dump[i]];
    }
    return output;
}

+ (NSString *)getHexString:(NSData *)data offset:(int)offset length:(int)length {
    uint8_t *dataBytes = (uint8_t*)[data bytes];
    uint8_t tempLen = dataBytes[offset];
    int len = tempLen & 0x7F;
    
    if (len > length + 1) {
        len = length - 1;
    }
    if(data.length < offset + len + 1){
        return @"";
    }
    NSData *subValue = [data subdataWithRange:NSMakeRange(offset + 1, len)];
    return [self getHexString:subValue];
}

+ (NSInteger)indexOf:(NSData *)data find:(uint8_t)value {
    uint8_t* array = (uint8_t*)data.bytes;
    int length = (int)data.length;
    for (int i = 0; i < length; i++) {
        if (array[i] == value) return i;
    }
    return -1;
}

+ (NSInteger)indexOfWithArray:(NSData *)data find:(NSData *)values {
    uint8_t* srcArray = (uint8_t*)data.bytes;
    int srcLength = (int)data.length;
    uint8_t* dstArray = (uint8_t*)values.bytes;
    int dstLength = (int)values.length;
    BOOL isMatching = NO;
    
    for (int i = 0; i < srcLength; i++) {
        for (int j = 0; j < dstLength; j++) {
            if (srcArray[i + j] == dstArray[j])
                isMatching = YES;
            else
                break;
        }
        if (isMatching == YES)
            return i;
    }
    return -1;
}

+ (NSRange)findDataWidthRange:(NSData *)data withPrefix:(uint8_t)prefix withSuffix1:(uint8_t)suffix1 withSuffix2:(uint8_t)suffix2 {
    uint8_t* array = (uint8_t*)data.bytes;
    int length = (int)data.length;
    NSInteger prefixPos = NSNotFound;
    NSInteger suffix1Pos = NSNotFound;
    NSInteger suffix2Pos = NSNotFound;
    BOOL is_DataCarry = NO;
    int tagLen = 0;
    int POS_DATA = 3;
    int POS_RESULT_DATA = 10;
    int POS_TAG = 0;
    BOOL barcodeflag = NO; /* multi-line barcode */
    
    for (int i = 0; i < length - 1; i++) {
        if (prefixPos == NSNotFound) {
            if (array[i] == prefix) {
                prefixPos = i;
                if(array[i+1] == 0x65)
                {
                    /*+ multi-line barcode +*/
                    if(array[i+2] == 0x43){
                        barcodeflag = YES;
                    } else {
                        barcodeflag = NO;
                    }
                    /*- multi-line barcode -*/
                    switch (array[i+2]) {
                        case 0x41:
                        {
                            is_DataCarry = YES;
                            POS_TAG = i+POS_RESULT_DATA;
                            uint8_t len = array[POS_TAG];
                            tagLen = (len & 0xFF) ;
                            break;
                        }
                        case 0x46:
                        case 0x54:
                        {
                            is_DataCarry = YES;
                            POS_TAG = i+POS_DATA;
                            uint8_t len = array[POS_TAG];
                            tagLen = (len & 0xFF) ;
                            break;
                        }
                    }
                }
                if(array[i+1] == 0x41)
                {
                    /*- multi-line barcode -*/
                    switch (array[i+2]) { 
                        case 0x72:
                        {
                            is_DataCarry = YES;
                            POS_TAG = i+POS_DATA;
                            uint8_t len = array[POS_TAG];
                            tagLen = (len & 0xFF) ;
                            break;
                        }
                    }
                }
                continue;
            }
        } else {
            /*+ multi-line barcode +*/
            if (barcodeflag == YES){
                if (array[i] == suffix1 && array[i+1] == suffix2 && array[i+2] == 0x7e && array[i+3] == 0x41 && array[i+4] == 0x73) {
                    if(is_DataCarry == YES)
                    {
                        if( i < (POS_TAG+tagLen))
                        {
                            continue;
                        }
                    }
                    suffix1Pos = i;
                    suffix2Pos = i+1;
                    break;
                }
            }else {
                if (array[i] == suffix1 && array[i+1] == suffix2) {
                    suffix1Pos = i;
                    suffix2Pos = i+1;
                    if(is_DataCarry == YES)
                    {
                        if( i >= (POS_TAG+tagLen))
                        {
                            break;
                        }
                    } else {
                        break;
                    }
                    
                }
            }
            /*- multi-line barcode -*/
        }
    }
    
    NSRange range;
    if (prefixPos == NSNotFound && suffix2Pos == NSNotFound)
        range = NSMakeRange(prefixPos, suffix2Pos);
    else if (prefixPos != NSNotFound && suffix2Pos == NSNotFound)
        range = NSMakeRange(prefixPos, NSNotFound);
    else if (prefixPos == NSNotFound && suffix2Pos != NSNotFound)
        range = NSMakeRange(prefixPos, suffix2Pos);
    else
        range = NSMakeRange(prefixPos, (suffix2Pos - prefixPos) + 1);
    return range;
}
+ (void)writeLog:(NSString *)log{
    if (CAN_WRITE_LOG) {
        NSLog(@"%@",log);
    }
}
+ (int)formatInputValue:(int)inputValue
               maxValue:(int)maxValue
               minValue:(int)minValue{
    if (inputValue > maxValue) {
        inputValue = maxValue;
    }
    if (inputValue < minValue) {
        inputValue = minValue;
    }
    return inputValue;
}
+ (NSData *)hexStringToData:(NSString *)hexString {
    if (!hexString || [hexString length] == 0) {
        return nil;
    }
    NSMutableData *hexData = [[NSMutableData alloc] initWithCapacity:8];
    NSRange range;
    if ([hexString length] % 2 == 0) {
        range = NSMakeRange(0, 2);
    } else {
        range = NSMakeRange(0, 1);
    }
    for (NSInteger i = range.location; i < [hexString length]; i += 2) {
        unsigned int anInt;
        NSString *hexCharStr = [hexString substringWithRange:range];
        NSScanner *scanner = [[NSScanner alloc] initWithString:hexCharStr];

        [scanner scanHexInt:&anInt];
        NSData *entity = [[NSData alloc] initWithBytes:&anInt length:1];
        [hexData appendData:entity];

        range.location += range.length;
        range.length = 2;
    }
    return hexData;
}
+ (NSString *)dataToString:(NSData *)data{
    NSString *hexStr=@"";
    @try {
        Byte *bytes=(Byte*)[data bytes];
        for(int i=0;i<[data length];i++){
            NSString *newHexStr=[NSString stringWithFormat:@"%x",bytes[i]&0xff];///16进制数
            if([newHexStr length]==1){
                hexStr=[NSString stringWithFormat:@"%@0%@",hexStr,newHexStr];
            } else {
                hexStr=[NSString stringWithFormat:@"%@%@",hexStr,newHexStr];
            }
        }
    } @catch (NSException *exception) {

    } @finally {

    }
    return hexStr;
}
@end

